/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.lbs.openaire;

import eu.dnetlib.lbs.events.input.MapValueType;
import eu.dnetlib.lbs.openaire.Range;
import eu.dnetlib.lbs.subscriptions.ConditionOperator;
import eu.dnetlib.lbs.subscriptions.ConditionParams;
import eu.dnetlib.lbs.subscriptions.MapCondition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class AdvQueryObject {
    private String datasource = "";
    private String topic = "";
    private List<String> titles = new ArrayList();
    private List<String> subjects = new ArrayList();
    private List<String> authors = new ArrayList();
    private List<Range> dates = new ArrayList();
    private Range trust = new Range("0", "1");

    public AdvQueryObject() {
    }

    public AdvQueryObject(String datasource, String topic, List<String> titles, List<String> subjects, List<String> authors, List<Range> dates, Range trust) {
        this.datasource = datasource;
        this.topic = topic;
        this.titles = titles;
        this.subjects = subjects;
        this.authors = authors;
        this.dates = dates;
        this.trust = trust;
    }

    public String getDatasource() {
        return this.datasource;
    }

    public void setDatasource(String datasource) {
        this.datasource = datasource;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public List<String> getTitles() {
        return this.titles;
    }

    public void setTitles(List<String> titles) {
        this.titles = titles;
    }

    public List<String> getSubjects() {
        return this.subjects;
    }

    public void setSubjects(List<String> subjects) {
        this.subjects = subjects;
    }

    public List<String> getAuthors() {
        return this.authors;
    }

    public void setAuthors(List<String> authors) {
        this.authors = authors;
    }

    public List<Range> getDates() {
        return this.dates;
    }

    public void setDates(List<Range> dates) {
        this.dates = dates;
    }

    public Range getTrust() {
        return this.trust;
    }

    public void setTrust(Range trust) {
        this.trust = trust;
    }

    public List<MapCondition> asListOfConditions() {
        ArrayList<MapCondition> list = new ArrayList<MapCondition>();
        List list_dates = this.dates.stream().filter(Range::isValid).map(d -> new ConditionParams(d.getMin(), d.getMax())).collect(Collectors.toList());
        List list_titles = this.titles.stream().filter(StringUtils::isNotBlank).map(t -> new ConditionParams(t, null)).collect(Collectors.toList());
        List list_authors = this.authors.stream().filter(StringUtils::isNotBlank).map(aut -> new ConditionParams(aut, null)).collect(Collectors.toList());
        List list_subjects = this.subjects.stream().filter(StringUtils::isNotBlank).map(s -> new ConditionParams(s, null)).collect(Collectors.toList());
        if (StringUtils.isNotBlank((CharSequence)this.datasource)) {
            list.add(new MapCondition("target_datasource_name", MapValueType.STRING, ConditionOperator.EXACT, Arrays.asList(new ConditionParams(this.datasource, null))));
        }
        if (this.trust.isValid()) {
            list.add(new MapCondition("trust", MapValueType.FLOAT, ConditionOperator.RANGE, Arrays.asList(new ConditionParams(this.trust.getMin(), this.trust.getMax()))));
        }
        if (!list_dates.isEmpty()) {
            list.add(new MapCondition("target_dateofacceptance", MapValueType.DATE, ConditionOperator.RANGE, list_dates));
        }
        if (!list_titles.isEmpty()) {
            list.add(new MapCondition("target_publication_title", MapValueType.LIST_STRING, ConditionOperator.MATCH_ALL, list_titles));
        }
        if (!list_authors.isEmpty()) {
            list.add(new MapCondition("target_publication_author_list", MapValueType.LIST_STRING, ConditionOperator.MATCH_ALL, list_authors));
        }
        if (!list_subjects.isEmpty()) {
            list.add(new MapCondition("target_publication_subject_list", MapValueType.LIST_STRING, ConditionOperator.MATCH_ALL, list_subjects));
        }
        return list;
    }
}

