/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.lbs.utils;

import com.google.gson.Gson;
import eu.dnetlib.lbs.elasticsearch.Event;
import eu.dnetlib.lbs.events.input.EventMessage;
import eu.dnetlib.lbs.events.input.MapValue;
import java.util.Date;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class JsonMessageToEventFunction
implements Function<String, Event> {
    private final Gson gson = new Gson();
    private static final Log log = LogFactory.getLog(JsonMessageToEventFunction.class);

    @Override
    public Event apply(String json) {
        try {
            EventMessage msg = (EventMessage)this.gson.fromJson(json, EventMessage.class);
            if (msg == null || msg.hasNulls()) {
                log.warn((Object)"Message is null or some required field is null");
                return null;
            }
            long now = new Date().getTime();
            Event event = new Event();
            event.setEventId("event-" + DigestUtils.md5Hex((String)msg.getTopic()).substring(0, 6) + "-" + JsonMessageToEventFunction.calculatePayloadHash((String)msg.getPayload()));
            event.setProducerId(msg.getProducerId());
            event.setPayload(msg.getPayload());
            event.setMap(msg.getMap().entrySet().stream().filter(e -> ((MapValue)e.getValue()).asObject() != null).collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((MapValue)e.getValue()).asObject())));
            event.setTopic(msg.getTopic());
            event.setCreationDate(Long.valueOf(now));
            event.setExpiryDate(this.calculateExpiryDate(now, msg.getTthDays()));
            event.setInstantMessage(msg.getTthDays() == 0);
            return event;
        }
        catch (Throwable e2) {
            log.warn((Object)("Error converting json: " + json), e2);
            return null;
        }
    }

    private Long calculateExpiryDate(long now, int ttlDays) {
        if (ttlDays < 0) {
            return null;
        }
        if (ttlDays == 0) {
            return now;
        }
        long duration = ttlDays * 24 * 60 * 60 * 1000;
        return now + duration;
    }

    private static String calculatePayloadHash(String payload) {
        return DigestUtils.md5Hex((String)payload);
    }
}

