package eu.dnetlib.lbs.events.input;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

import eu.dnetlib.lbs.elasticsearch.Event;
import eu.dnetlib.lbs.properties.RabbitMQProperties;
import eu.dnetlib.lbs.utils.LbsQueue;

@Component
@ConditionalOnProperty(prefix = "lbs.rabbit", name = "enabled")
public class RabbitMQConsumerFactory {

	@Autowired
	private RabbitMQProperties props;

	public RabbitMQConsumer newConsumer(final LbsQueue<String, Event> localQueue) {
		final String queue = this.props.getQueue();
		final String host = this.props.getHost();
		final int port = this.props.getPort();
		final String username = this.props.getUsername();
		final String password = this.props.getPassword();
		return new RabbitMQConsumer(queue, host, port, username, password, localQueue);
	}

}
