package eu.dnetlib.lbs.controllers.objects;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import eu.dnetlib.lbs.properties.DatabaseProperties;
import eu.dnetlib.lbs.properties.ElasticSearchProperties;
import eu.dnetlib.lbs.properties.EmailProperties;
import eu.dnetlib.lbs.properties.RabbitMQProperties;

@Component
public class CurrentStatus {

	@Autowired
	private DatabaseProperties h2;
	@Autowired
	private ElasticSearchProperties elasticSearch;
	@Autowired
	private RabbitMQProperties rabbitMQ;
	@Autowired
	private EmailProperties emails;

	private List<ThreadStatus> threads;
	private List<BufferStatus> buffers = new ArrayList<>();
	private List<DispatcherStatus> dispatchers = new ArrayList<>();
	private final Map<String, Long> totals = new HashMap<>();

	public EmailProperties getEmails() {
		return this.emails;
	}

	public void setEmails(final EmailProperties emails) {
		this.emails = emails;
	}

	public List<ThreadStatus> getThreads() {
		return this.threads;
	}

	public void setThreads(final List<ThreadStatus> threads) {
		this.threads = threads;
	}

	public List<BufferStatus> getBuffers() {
		return this.buffers;
	}

	public void setBuffers(final List<BufferStatus> buffers) {
		this.buffers = buffers;
	}

	public List<DispatcherStatus> getDispatchers() {
		return this.dispatchers;
	}

	public void setDispatchers(final List<DispatcherStatus> dispatchers) {
		this.dispatchers = dispatchers;
	}

	public Map<String, Long> getTotals() {
		return this.totals;
	}

	public ElasticSearchProperties getElasticSearch() {
		return this.elasticSearch;
	}

	public void setElasticSearch(final ElasticSearchProperties elasticSearch) {
		this.elasticSearch = elasticSearch;
	}

	public RabbitMQProperties getRabbitMQ() {
		return this.rabbitMQ;
	}

	public void setRabbitMQ(final RabbitMQProperties rabbitMQ) {
		this.rabbitMQ = rabbitMQ;
	}

	public DatabaseProperties getH2() {
		return this.h2;
	}

	public void setH2(final DatabaseProperties h2) {
		this.h2 = h2;
	}

}
