package eu.dnetlib.lbs.properties;

import javax.validation.constraints.NotNull;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix = "lbs.elastic")
public class ElasticSearchProperties {

	@NotNull
	private String clusterNodes;
	@NotNull
	private String clusterName;
	@NotNull
	private String homepage;
	@NotNull
	private String eventsIndexName;
	@NotNull
	private String eventsIndexType;
	@NotNull
	private String notificationsIndexName;
	@NotNull
	private String notificationsIndexType;

	public String getClusterNodes() {
		return this.clusterNodes;
	}

	public void setClusterNodes(final String clusterNodes) {
		this.clusterNodes = clusterNodes;
	}

	public String getClusterName() {
		return this.clusterName;
	}

	public void setClusterName(final String clusterName) {
		this.clusterName = clusterName;
	}

	public String getHomepage() {
		return this.homepage;
	}

	public void setHomepage(final String homepage) {
		this.homepage = homepage;
	}

	public String getEventsIndexName() {
		return this.eventsIndexName;
	}

	public void setEventsIndexName(final String eventsIndexName) {
		this.eventsIndexName = eventsIndexName;
	}

	public String getEventsIndexType() {
		return this.eventsIndexType;
	}

	public void setEventsIndexType(final String eventsIndexType) {
		this.eventsIndexType = eventsIndexType;
	}

	public String getNotificationsIndexName() {
		return this.notificationsIndexName;
	}

	public void setNotificationsIndexName(final String notificationsIndexName) {
		this.notificationsIndexName = notificationsIndexName;
	}

	public String getNotificationsIndexType() {
		return this.notificationsIndexType;
	}

	public void setNotificationsIndexType(final String notificationsIndexType) {
		this.notificationsIndexType = notificationsIndexType;
	}

}
