package eu.dnetlib.loginservice.security.oidc;

import eu.dnetlib.loginservice.properties.Properties;
import eu.dnetlib.loginservice.utils.Redirect;
import org.apache.log4j.Logger;
import org.mitre.openid.connect.client.OIDCAuthenticationFilter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

public class OpenAIREAuthenticationFilter extends OIDCAuthenticationFilter {

    private final static Logger logger = Logger.getLogger(OpenAIREAuthenticationSuccessHandler.class);
    private final Properties properties;

    public OpenAIREAuthenticationFilter(Properties properties) {
        super();
        this.properties = properties;
    }

    @Override
    protected void handleAuthorizationRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Redirect.setRedirect(request, properties);
        super.handleAuthorizationRequest(request, response);
    }
}
