/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.loginservice.security;

import eu.dnetlib.loginservice.properties.Properties;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.session.data.redis.config.annotation.web.http.EnableRedisHttpSession;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.DefaultCookieSerializer;

@EnableRedisHttpSession
@Configuration
public class RedisConfig {
    private final Properties properties;
    private static final Logger logger = Logger.getLogger(RedisConfig.class);

    @Autowired
    public RedisConfig(Properties properties) {
        this.properties = properties;
    }

    @Bean
    public LettuceConnectionFactory connectionFactory() {
        logger.info((Object)String.format("Redis connection listens to %s:%s ", this.properties.getRedis().getHost(), this.properties.getRedis().getPort()));
        LettuceConnectionFactory factory = new LettuceConnectionFactory(this.properties.getRedis().getHost(), Integer.parseInt(this.properties.getRedis().getPort()));
        if (this.properties.getRedis().getPassword() != null) {
            factory.setPassword(this.properties.getRedis().getPassword());
        }
        return factory;
    }

    @Bean
    public CookieSerializer cookieSerializer() {
        DefaultCookieSerializer serializer = new DefaultCookieSerializer();
        serializer.setCookieName(this.properties.getSession());
        serializer.setCookiePath("/");
        serializer.setDomainName(this.properties.getDomain());
        return serializer;
    }
}

