/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintools.configuration.mongo;

import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import eu.dnetlib.uoaadmintools.configuration.properties.MongoConfig;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoDbFactory;
import org.springframework.data.mongodb.repository.config.EnableMongoRepositories;

@Configuration
@EnableMongoRepositories(basePackages={"eu.dnetlib.uoaadmintools.dao", "eu.dnetlib.uoaadmintoolslibrary.dao"})
public class MongoConnection {
    @Autowired
    private MongoConfig mongoConfig;

    @Bean
    @Primary
    public MongoDbFactory mongoDbFactory() {
        return new SimpleMongoDbFactory(this.getMongoClient(), this.mongoConfig.getDatabase());
    }

    @Bean(name={"mongoTemplate"})
    @Primary
    public MongoTemplate getMongoTemplate() {
        return new MongoTemplate(this.mongoDbFactory());
    }

    private MongoClient getMongoClient() {
        if (this.mongoConfig.getUsername() != null && this.mongoConfig.getPassword() != null) {
            return new MongoClient(Collections.singletonList(new ServerAddress(this.mongoConfig.getHost(), this.mongoConfig.getPort())), Collections.singletonList(MongoCredential.createCredential((String)this.mongoConfig.getUsername(), (String)this.mongoConfig.getDatabase(), (char[])this.mongoConfig.getPassword().toCharArray())));
        }
        return new MongoClient(Collections.singletonList(new ServerAddress(this.mongoConfig.getHost(), this.mongoConfig.getPort())));
    }
}

