/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintools.controllers;

import eu.dnetlib.uoaadmintools.entities.Layout;
import eu.dnetlib.uoaadmintools.services.LayoutService;
import eu.dnetlib.uoaadmintoolslibrary.entities.Portal;
import eu.dnetlib.uoaadmintoolslibrary.entities.fullEntities.PortalResponse;
import eu.dnetlib.uoaadmintoolslibrary.handlers.ContentNotFoundException;
import eu.dnetlib.uoaadmintoolslibrary.handlers.MismatchingContentException;
import eu.dnetlib.uoaadmintoolslibrary.services.PortalService;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/connect"})
@CrossOrigin(origins={"*"})
public class ConnectController {
    private final Logger log = Logger.getLogger(this.getClass());
    @Autowired
    private LayoutService layoutService;
    @Autowired
    private PortalService portalService;

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN)")
    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public PortalResponse updateConnect(@RequestBody Portal portal) {
        String new_pid;
        if (!portal.getType().equals("connect")) {
            throw new MismatchingContentException("Update Connect: Portal with id: " + portal.getId() + " has type: " + portal.getType() + " instead of connect");
        }
        PortalResponse portalResponse = this.portalService.updatePortal(portal);
        String old_pid = portalResponse.getPid();
        if (!old_pid.equals(new_pid = portal.getPid())) {
            this.layoutService.updatePid(old_pid, new_pid);
        }
        return portalResponse;
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN)")
    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public PortalResponse insertConnect(@RequestBody Portal portal) {
        if (!portal.getType().equals("connect")) {
            throw new MismatchingContentException("Save Connect: Portal with id: " + portal.getId() + " has type: " + portal.getType() + " instead of connect");
        }
        PortalResponse portalResponse = this.portalService.insertPortal(portal);
        return portalResponse;
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN)")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public Boolean deleteConnect(@RequestBody List<String> portals) {
        for (String id : portals) {
            Portal portal = this.portalService.getPortalById(id);
            if (portal == null) {
                throw new ContentNotFoundException("Delete connect: Portal with id: " + id + " not found");
            }
            if (!portal.getType().equals("connect")) {
                throw new MismatchingContentException("Delete Connect: Portal with id: " + id + " has type: " + portal.getType() + " instead of connect");
            }
            String pid = this.portalService.deletePortal(id);
            this.layoutService.deleteByPid(pid);
        }
        return true;
    }

    @RequestMapping(value={"/{pid}/layout"}, method={RequestMethod.GET})
    public Layout getLayoutForConnect(@PathVariable(value="pid") String pid) {
        if (!pid.equals("connect") && !pid.equals("default")) {
            throw new MismatchingContentException("ConnectController - Get layout: Not accepted pid: " + pid);
        }
        return this.layoutService.findByPid(pid);
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN)")
    @RequestMapping(value={"/{pid}/layout"}, method={RequestMethod.POST})
    public Layout updateLayoutForConnect(@PathVariable(value="pid") String pid, @RequestBody Layout layout) {
        if (!pid.equals("connect") && !pid.equals("default")) {
            throw new MismatchingContentException("ConnectController - Update layout: Not accepted pid: " + pid);
        }
        if (!pid.equals(layout.getPortalPid())) {
            throw new MismatchingContentException("ConnectController - Update layout: Portal has pid: " + pid + " while layout has portalPid: " + layout.getPortalPid());
        }
        return this.layoutService.save(layout);
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN)")
    @RequestMapping(value={"/{pid}/layout"}, method={RequestMethod.DELETE})
    public boolean deleteLayoutForConnect(@PathVariable(value="pid") String pid) {
        if (!pid.equals("connect") && !pid.equals("default")) {
            throw new MismatchingContentException("ConnectController - Delete layout: Not accepted pid: " + pid);
        }
        return this.layoutService.deleteByPid(pid);
    }
}

