/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintools.controllers;

import eu.dnetlib.uoaadmintools.entities.curator.Curator;
import eu.dnetlib.uoaadmintools.entities.curator.CuratorResponse;
import eu.dnetlib.uoaadmintools.services.CuratorService;
import eu.dnetlib.uoaadmintoolslibrary.handlers.ContentNotFoundException;
import eu.dnetlib.uoaadmintoolslibrary.handlers.utils.RolesUtils;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
public class CuratorController {
    private final Logger log = Logger.getLogger(this.getClass());
    @Autowired
    private CuratorService curatorService;
    @Autowired
    private RolesUtils rolesUtils;

    @RequestMapping(value={"/{pid}/curator"}, method={RequestMethod.GET})
    public List<CuratorResponse> getCurators(@PathVariable String pid) {
        return this.curatorService.getCurators(pid);
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/curator"}, method={RequestMethod.GET})
    public Curator getCuratorById() {
        Curator curator = this.curatorService.findById(this.getId());
        if (curator != null) {
            return curator;
        }
        throw new ContentNotFoundException("No curator found");
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/curator"}, method={RequestMethod.POST})
    public Curator insertCurator(@RequestBody Curator curator) {
        curator.setId(this.getId());
        return this.curatorService.save(curator);
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN)")
    @RequestMapping(value={"/{pid}/curator"}, method={RequestMethod.DELETE})
    public void deleteCurators(@PathVariable String pid) {
        this.curatorService.deleteCurators(pid);
    }

    private String getId() {
        String aaiId = this.rolesUtils.getAaiId();
        return aaiId.substring(0, aaiId.indexOf("@"));
    }
}

