/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintools.controllers;

import eu.dnetlib.uoaadmintools.dao.SubscriberDAO;
import eu.dnetlib.uoaadmintools.entities.subscriber.Subscriber;
import eu.dnetlib.uoaadmintoolslibrary.handlers.ContentNotFoundException;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
public class SubscriberController {
    private final Logger log = Logger.getLogger(this.getClass());
    @Autowired
    private SubscriberDAO subscriberDAO;

    @RequestMapping(value={"/subscriber"}, method={RequestMethod.GET})
    public List<Subscriber> getSubscriber() throws ContentNotFoundException {
        List list = this.subscriberDAO.findAll();
        if (list == null) {
            throw new ContentNotFoundException("Subscribers not found");
        }
        return this.subscriberDAO.findAll();
    }

    @RequestMapping(value={"/subscriber/{email}"}, method={RequestMethod.GET})
    public Subscriber getSubscriber(@PathVariable(value="email", required=true) String email) throws ContentNotFoundException {
        Subscriber subscriber = this.subscriberDAO.findByEmail(email);
        if (subscriber == null) {
            throw new ContentNotFoundException("Subscribers not found");
        }
        return subscriber;
    }
}

