/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintools.services;

import eu.dnetlib.uoaadmintools.dao.CuratorDAO;
import eu.dnetlib.uoaadmintools.entities.Manager;
import eu.dnetlib.uoaadmintools.entities.curator.Curator;
import eu.dnetlib.uoaadmintools.entities.curator.CuratorResponse;
import eu.dnetlib.uoaadmintools.services.ManagerService;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CuratorService {
    private final Logger log = Logger.getLogger(this.getClass());
    @Autowired
    private CuratorDAO curatorDAO;
    @Autowired
    private ManagerService managerService;

    public List<CuratorResponse> getCurators(String pid) {
        ArrayList<CuratorResponse> curators = new ArrayList<CuratorResponse>();
        for (Manager manager : this.managerService.getManagers(pid, ManagerService.Type.ID)) {
            Curator curator = this.curatorDAO.findById(this.parseId(manager.getId()));
            if (curator == null) continue;
            curators.add(new CuratorResponse(curator));
        }
        return curators;
    }

    public Curator findById(String id) {
        return this.curatorDAO.findById(id);
    }

    public Curator save(Curator curator) {
        return this.curatorDAO.save(curator);
    }

    public void deleteCurators(String pid) {
        for (Manager manager : this.managerService.getManagers(pid, ManagerService.Type.ID)) {
            Curator curator = this.curatorDAO.findById(this.parseId(manager.getId()));
            if (curator == null) continue;
            this.curatorDAO.delete(curator.getId());
        }
    }

    private String parseId(String id) {
        return id.substring(0, id.indexOf("@"));
    }
}

