/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintools.controllers;

import eu.dnetlib.uoaadmintools.dao.NotificationsDAO;
import eu.dnetlib.uoaadmintools.entities.Manager;
import eu.dnetlib.uoaadmintools.entities.Notifications;
import eu.dnetlib.uoaadmintools.services.ManagerService;
import eu.dnetlib.uoaadmintoolslibrary.dao.PortalDAO;
import eu.dnetlib.uoaadmintoolslibrary.emailSender.EmailSender;
import eu.dnetlib.uoaadmintoolslibrary.entities.email.Email;
import eu.dnetlib.uoaadmintoolslibrary.entities.email.EmailRecaptcha;
import eu.dnetlib.uoaadmintoolslibrary.handlers.ContentNotFoundException;
import eu.dnetlib.uoaadmintoolslibrary.handlers.InvalidReCaptchaException;
import eu.dnetlib.uoaadmintoolslibrary.handlers.utils.RolesUtils;
import eu.dnetlib.uoaadmintoolslibrary.recaptcha.VerifyRecaptcha;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
public class EmailController {
    private final Logger log = Logger.getLogger(this.getClass());
    @Autowired
    private EmailSender emailSender;
    @Autowired
    private NotificationsDAO notificationsDAO;
    @Autowired
    private PortalDAO portalDAO;
    @Autowired
    private VerifyRecaptcha verifyRecaptcha;
    @Autowired
    private ManagerService managerService;
    @Autowired
    private RolesUtils rolesUtils;

    @RequestMapping(value={"/contact"}, method={RequestMethod.POST})
    public Boolean contact(@RequestBody EmailRecaptcha form) throws InvalidReCaptchaException {
        if (form.getRecaptcha() != null) {
            this.verifyRecaptcha.processResponse(form.getRecaptcha());
        }
        Email email = form.getEmail();
        ArrayList sendTo = new ArrayList(email.getRecipients());
        return this.emailSender.send(sendTo, email.getSubject(), email.getBody(), Boolean.valueOf(false));
    }

    @RequestMapping(value={"/sendMail"}, method={RequestMethod.POST})
    public Map<String, ArrayList<String>> sendEmail(@RequestBody Email email, @RequestParam(required=false) Optional<Boolean> optional) {
        String successString = "success";
        String failureString = "failure";
        HashMap<String, ArrayList<String>> mailResults = new HashMap<String, ArrayList<String>>();
        boolean bcc = optional.isPresent() ? optional.get() : true;
        for (String userMail : email.getRecipients()) {
            ArrayList<String> sendTo = new ArrayList<String>();
            sendTo.add(userMail);
            boolean success = this.emailSender.send(sendTo, email.getSubject(), email.getBody(), Boolean.valueOf(bcc));
            if (success) {
                if (!mailResults.containsKey(successString)) {
                    mailResults.put(successString, new ArrayList());
                }
                ((ArrayList)mailResults.get(successString)).add(userMail);
                continue;
            }
            if (!mailResults.containsKey(failureString)) {
                mailResults.put(failureString, new ArrayList());
            }
            ((ArrayList)mailResults.get(failureString)).add(userMail);
        }
        return mailResults;
    }

    @RequestMapping(value={"/notifyNewManager"}, method={RequestMethod.POST})
    public Boolean notifyNewManager(@RequestBody Email email) throws Exception {
        String userMail = this.rolesUtils.getEmail();
        ArrayList<String> sendTo = new ArrayList<String>();
        sendTo.add(userMail);
        boolean success = this.emailSender.send(sendTo, email.getSubject(), email.getBody(), Boolean.valueOf(true));
        return success;
    }

    @RequestMapping(value={"/notifyManagers/{pid}/{newRoleType}"}, method={RequestMethod.POST})
    public Boolean notifyManagers(@PathVariable(value="pid") String pid, @PathVariable(value="newRoleType") String newRoleType, @RequestBody Email email) throws Exception {
        ArrayList<String> notifyrecipients = new ArrayList<String>();
        if (this.portalDAO.findByPid(pid) == null) {
            throw new ContentNotFoundException("Portal not found");
        }
        Manager[] managers = this.managerService.getManagers(pid);
        ArrayList<String> emails = new ArrayList<String>();
        for (Manager manager : managers) {
            Notifications userNotifications;
            String userEmail = manager.getEmail();
            emails.add(userEmail);
            if (userEmail.equals(this.rolesUtils.getEmail()) || (userNotifications = this.notificationsDAO.findByManagerEmailAndPortalPid(userEmail, pid)) != null && (!newRoleType.equals("manager") || !userNotifications.getNotifyForNewManagers().booleanValue()) && (!newRoleType.equals("subscriber") || !userNotifications.getNotifyForNewSubscribers().booleanValue())) continue;
            notifyrecipients.add(userEmail);
        }
        if (notifyrecipients.size() > 0) {
            email.setBody(email.getBody().replace("((__managers__))", String.join((CharSequence)", ", emails)));
            return this.emailSender.send(notifyrecipients, email.getSubject(), email.getBody(), Boolean.valueOf(false));
        }
        this.log.debug((Object)"There are no users to notify ");
        return true;
    }

    @RequestMapping(value={"/test"}, method={RequestMethod.GET})
    public String test() throws Exception {
        this.log.debug((Object)"Test mail");
        ArrayList<String> mails = new ArrayList<String>();
        mails.add("argirok@di.uoa.gr");
        mails.add("argirokokogiannaki@gmail.com");
        this.log.debug((Object)("Recipients" + mails));
        Email email = new Email();
        email.setRecipients(mails);
        email.setBody("Test body");
        email.setSubject("Test theme");
        String response = "";
        response = response + this.notifyManagers("ee", "manager", email);
        this.log.debug((Object)("Notify managers " + response));
        response = response + " ";
        response = response + this.notifyManagers("ee", "subscriber", email);
        this.log.debug((Object)("Notify for subscr " + response));
        return response;
    }
}

