/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintools.controllers;

import eu.dnetlib.uoaadmintools.dao.PortalSubscribersDAO;
import eu.dnetlib.uoaadmintools.dao.SubscriberDAO;
import eu.dnetlib.uoaadmintools.entities.subscriber.PortalSubscribers;
import eu.dnetlib.uoaadmintoolslibrary.dao.PortalDAO;
import eu.dnetlib.uoaadmintoolslibrary.handlers.ContentNotFoundException;
import eu.dnetlib.uoaadmintoolslibrary.responses.SingleValueWrapperResponse;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
public class PortalSubscribersController {
    @Autowired
    PortalSubscribersDAO portalSubscribersDAO;
    @Autowired
    SubscriberDAO subscriberDAO;
    @Autowired
    PortalDAO portalDAO;
    private final Logger log = Logger.getLogger(this.getClass());

    @RequestMapping(value={"/community/{pid}/subscribers/count"}, method={RequestMethod.GET})
    public SingleValueWrapperResponse<Integer> getNumberOfSubscribersPerPortal(@PathVariable(value="pid", required=true) String pid) throws ContentNotFoundException {
        SingleValueWrapperResponse singleValueWrapperResponse = new SingleValueWrapperResponse((Object)0);
        PortalSubscribers portalSubscribers = this.portalSubscribersDAO.findByPid(pid);
        if (portalSubscribers != null) {
            if (portalSubscribers.getSubscribers() != null) {
                singleValueWrapperResponse.setValue((Object)portalSubscribers.getSubscribers().size());
            }
        } else {
            throw new ContentNotFoundException("Portal Subscribers not found");
        }
        return singleValueWrapperResponse;
    }

    @RequestMapping(value={"/community/subscribers"}, method={RequestMethod.GET})
    public List<PortalSubscribers> getAllPortalSubscribers() {
        return this.portalSubscribersDAO.findAll();
    }

    @RequestMapping(value={"/community/{pid}/subscribers"}, method={RequestMethod.GET})
    public PortalSubscribers getSubscribersPerPortal(@PathVariable(value="pid", required=true) String pid) throws ContentNotFoundException {
        PortalSubscribers portalSubscribers = this.portalSubscribersDAO.findByPid(pid);
        if (portalSubscribers != null) {
            return portalSubscribers;
        }
        throw new ContentNotFoundException("Portal Subscribers not found");
    }
}

