/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintools.services;

import eu.dnetlib.uoaadmintools.dao.StatisticsDAO;
import eu.dnetlib.uoaadmintools.entities.statistics.Statistics;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StatisticsService {
    private final Logger log = Logger.getLogger(this.getClass());
    @Autowired
    private StatisticsDAO statisticsDAO;

    public void updatePid(String old_pid, String new_pid) {
        this.log.debug((Object)"statistics service: updatePid");
        Statistics statistics = this.statisticsDAO.findByPid(old_pid);
        this.log.debug((Object)("statistics service: statistics id: " + (statistics != null ? statistics.getId() : "not found")));
        if (statistics != null) {
            statistics.setPid(new_pid);
            this.log.debug((Object)("statistics service: new statistics pid: " + statistics.getPid()));
            this.statisticsDAO.save(statistics);
            this.log.debug((Object)"statistics saved!");
        }
    }

    public void createPortalStatistics(String pid) {
        Statistics statistics = new Statistics(pid);
        this.statisticsDAO.save(statistics);
    }

    public void deleteByPid(String pid) {
        Statistics stats = this.statisticsDAO.findByPid(pid);
        if (stats != null) {
            this.statisticsDAO.delete(stats.getId());
        }
    }
}

