/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintools.controllers;

import eu.dnetlib.uoaadmintools.configuration.properties.BrowserCacheConfig;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

@RestController
@RequestMapping(value={"/cache"})
@CrossOrigin(origins={"*"})
public class BrowserCacheController {
    private final Logger log = Logger.getLogger(this.getClass());
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private BrowserCacheConfig config;

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator('community'), @AuthorizationService.manager('community', #pid))")
    @RequestMapping(value={"/{pid}"}, method={RequestMethod.GET})
    public boolean purge(@PathVariable(value="pid") String pid) {
        try {
            ResponseEntity responseEntity = this.restTemplate.getForEntity(this.config.getUrl().replace("{community}", pid), Object.class, new Object[0]);
        }
        catch (HttpClientErrorException httpClientErrorException) {
            this.log.debug((Object)("Purge browser cache: HttpClientErrorException for " + pid + " - code: " + httpClientErrorException.getStatusCode()));
        }
        catch (ResourceAccessException resourceAccessException) {
            this.log.debug((Object)("Purge browser cache: ResourceAccessException for " + pid));
        }
        catch (Exception exception) {
            this.log.debug((Object)("Purge browser cache: " + exception.getClass() + " for " + pid));
        }
        return true;
    }
}

