/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintools.controllers;

import eu.dnetlib.uoaadmintools.entities.Layout;
import eu.dnetlib.uoaadmintools.services.LayoutService;
import eu.dnetlib.uoaadmintools.services.MenuService;
import eu.dnetlib.uoaadmintools.services.NotificationsService;
import eu.dnetlib.uoaadmintools.services.StatisticsService;
import eu.dnetlib.uoaadmintools.services.SubscriberService;
import eu.dnetlib.uoaadmintoolslibrary.entities.Portal;
import eu.dnetlib.uoaadmintoolslibrary.entities.fullEntities.PortalResponse;
import eu.dnetlib.uoaadmintoolslibrary.handlers.ContentNotFoundException;
import eu.dnetlib.uoaadmintoolslibrary.handlers.MismatchingContentException;
import eu.dnetlib.uoaadmintoolslibrary.handlers.utils.RolesUtils;
import eu.dnetlib.uoaadmintoolslibrary.services.PortalService;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/community"})
@CrossOrigin(origins={"*"})
public class CommunityController {
    private final Logger log = Logger.getLogger(this.getClass());
    @Autowired
    private RolesUtils rolesUtils;
    @Autowired
    private LayoutService layoutService;
    @Autowired
    private NotificationsService notificationsService;
    @Autowired
    private StatisticsService statisticsService;
    @Autowired
    private SubscriberService subscriberService;
    @Autowired
    private MenuService menuService;
    @Autowired
    private PortalService portalService;

    @RequestMapping(value={""}, method={RequestMethod.GET})
    public List<Portal> getAllCommunities() {
        return this.portalService.getAllPortalsByType("community");
    }

    @RequestMapping(value={"/full"}, method={RequestMethod.GET})
    public List<PortalResponse> getAllCommunitiesFull() {
        return this.portalService.getAllPortalsFullByType("community");
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN)")
    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public PortalResponse updateCommunity(@RequestBody Portal portal) {
        if (!portal.getType().equals("community")) {
            throw new MismatchingContentException("Update Community: Portal with id: " + portal.getId() + " has type: " + portal.getType() + " instead of community");
        }
        String old_pid = this.portalService.getPortalById(portal.getId()).getPid();
        String new_pid = portal.getPid();
        PortalResponse portalResponse = this.portalService.updatePortal(portal);
        if (!old_pid.equals(new_pid)) {
            this.log.debug((Object)("update portal pid - old: " + old_pid + " - new: " + new_pid));
            this.statisticsService.updatePid(old_pid, new_pid);
            this.subscriberService.updatePid(old_pid, new_pid);
            this.layoutService.updatePid(old_pid, new_pid);
            this.notificationsService.updatePid(old_pid, new_pid);
        }
        return portalResponse;
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN)")
    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public PortalResponse insertCommunity(@RequestBody Portal portal) {
        if (!portal.getType().equals("community")) {
            throw new MismatchingContentException("Save Community: Portal with id: " + portal.getId() + " has type: " + portal.getType() + " instead of community");
        }
        PortalResponse portalResponse = this.portalService.insertPortal(portal);
        this.statisticsService.createPortalStatistics(portal.getPid());
        this.subscriberService.createPortalSubscribers(portal.getPid());
        return portalResponse;
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN)")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public Boolean deleteCommunities(@RequestBody List<String> portals) throws Exception {
        List roles = this.rolesUtils.getRoles();
        for (String id : portals) {
            Portal portal = this.portalService.getPortalById(id);
            if (portal == null) {
                throw new ContentNotFoundException("Delete community: Portal with id: " + id + " not found");
            }
            if (!portal.getType().equals("community")) {
                throw new MismatchingContentException("Delete Community: Portal with id: " + id + " has type: " + portal.getType() + " instead of community");
            }
            String pid = this.portalService.deletePortal(id);
            this.statisticsService.deleteByPid(pid);
            this.subscriberService.deletePortalSubscribers(pid);
            this.layoutService.deleteByPid(pid);
            this.notificationsService.deleteByPid(pid);
            this.menuService.deleteMenuByPortalPid(pid);
        }
        return true;
    }

    @RequestMapping(value={"/layouts"}, method={RequestMethod.GET})
    public List<Layout> getAvailableLayouts() {
        return this.layoutService.findAll();
    }

    @RequestMapping(value={"/{pid}/layout"}, method={RequestMethod.GET})
    public Layout getLayoutForCommunity(@PathVariable(value="pid") String pid) {
        Portal portal = this.portalService.getPortal(pid);
        if (portal == null) {
            throw new ContentNotFoundException("CommunityController - Get layout: Portal with pid: " + pid + " not found");
        }
        if (!portal.getType().equals("community")) {
            throw new MismatchingContentException("CommunityController - Get layout: Portal with pid: " + pid + " has type: " + portal.getType() + " instead of community");
        }
        return this.layoutService.findByPid(pid);
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator('community'), @AuthorizationService.manager('community', #pid))")
    @RequestMapping(value={"/{pid}/layout"}, method={RequestMethod.POST})
    public Layout updateLayoutForCommunity(@PathVariable(value="pid") String pid, @RequestBody Layout layout) {
        Portal portal = this.portalService.getPortal(pid);
        if (portal == null) {
            throw new ContentNotFoundException("CommunityController - Update layout: Portal with pid: " + pid + " not found");
        }
        if (!portal.getType().equals("community")) {
            throw new MismatchingContentException("CommunityController - Update layout: Portal with pid: " + pid + " has type: " + portal.getType() + " instead of community");
        }
        if (!pid.equals(layout.getPortalPid())) {
            throw new MismatchingContentException("CommunityController - Update layout: Portal has pid: " + pid + " while layout has portalPid: " + layout.getPortalPid());
        }
        return this.layoutService.save(layout);
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator('community'))")
    @RequestMapping(value={"/{pid}/layout"}, method={RequestMethod.DELETE})
    public boolean deleteLayoutForCommunity(@PathVariable(value="pid") String pid) {
        Portal portal = this.portalService.getPortal(pid);
        if (portal == null) {
            throw new ContentNotFoundException("CommunityController - Delete layout: Portal with pid: " + pid + " not found");
        }
        if (!portal.getType().equals("community")) {
            throw new MismatchingContentException("CommunityController - Delete layout: Portal with pid: " + pid + " has type: " + portal.getType() + " instead of community");
        }
        return this.layoutService.deleteByPid(pid);
    }
}

