/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintools.services;

import eu.dnetlib.uoaadmintools.dao.LayoutDAO;
import eu.dnetlib.uoaadmintools.entities.Layout;
import eu.dnetlib.uoaadmintoolslibrary.handlers.MismatchingContentException;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LayoutService {
    private final Logger log = Logger.getLogger(this.getClass());
    @Autowired
    private LayoutDAO layoutDAO;

    public List<Layout> findAll() {
        return this.layoutDAO.findAll();
    }

    public void updatePid(String old_pid, String new_pid) {
        this.log.debug((Object)"layout service: updatePid");
        List layouts = this.layoutDAO.findByPortalPid(old_pid);
        for (Layout layout : layouts) {
            this.log.debug((Object)("layout service: layout id: " + (layout != null ? layout.getId() : "not found")));
            if (layout == null) continue;
            layout.setPortalPid(new_pid);
            this.log.debug((Object)("layout layout: new layout pid: " + layout.getPortalPid()));
            this.layoutDAO.save(layout);
            this.log.debug((Object)"layout saved!");
        }
    }

    public boolean deleteByPid(String pid) {
        List layouts = this.layoutDAO.findByPortalPid(pid);
        for (Layout layout : layouts) {
            if (layout == null) continue;
            if (!pid.equals(layout.getPortalPid())) {
                throw new MismatchingContentException("Delete layout by pid: Portal has pid: " + pid + " while layout has portalPid: " + layout.getPortalPid());
            }
            this.layoutDAO.delete(layout.getId());
        }
        return true;
    }

    public Layout findByPid(String pid) {
        List layouts = this.layoutDAO.findByPortalPid(pid);
        if (layouts != null && layouts.size() > 0) {
            return (Layout)layouts.get(0);
        }
        return null;
    }

    public Layout save(Layout layout) {
        List oldLayouts = this.layoutDAO.findByPortalPid(layout.getPortalPid());
        if (oldLayouts != null && oldLayouts.size() == 1) {
            layout.setId(((Layout)oldLayouts.get(0)).getId());
        }
        return this.layoutDAO.save(layout);
    }
}

