/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintools.services;

import eu.dnetlib.uoaadmintools.configuration.properties.ManagersApiConfig;
import eu.dnetlib.uoaadmintools.entities.Manager;
import eu.dnetlib.uoaadmintools.services.ManagerService;
import eu.dnetlib.uoaadmintoolslibrary.handlers.ContentNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class ManagerService {
    @Autowired
    private ManagersApiConfig config;
    @Autowired
    private RestTemplate restTemplate;

    public Manager[] getManagers(String pid) {
        return this.getManagers(pid, Type.EMAIL);
    }

    public Manager[] getManagers(String pid, Type type) {
        String url = type == Type.EMAIL ? this.config.getEmail() : this.config.getId();
        ResponseEntity responseEntity = this.restTemplate.getForEntity(url.replace("{community}", pid), Manager[].class, new Object[0]);
        Manager[] managers = (Manager[])responseEntity.getBody();
        if (managers != null && responseEntity.getStatusCode() == HttpStatus.OK) {
            return managers;
        }
        throw new ContentNotFoundException("No managers has been found for community " + pid);
    }
}

