/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintools.services;

import eu.dnetlib.uoaadmintools.dao.MenuDAO;
import eu.dnetlib.uoaadmintools.dao.MenuItemDAO;
import eu.dnetlib.uoaadmintools.entities.menu.Menu;
import eu.dnetlib.uoaadmintools.entities.menu.MenuFull;
import eu.dnetlib.uoaadmintools.entities.menu.MenuItem;
import eu.dnetlib.uoaadmintools.entities.menu.MenuItemFull;
import eu.dnetlib.uoaadmintoolslibrary.handlers.ContentNotFoundException;
import eu.dnetlib.uoaadmintoolslibrary.handlers.MismatchingContentException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MenuService {
    private final Logger log = Logger.getLogger(this.getClass());
    @Autowired
    private MenuDAO menuDAO;
    @Autowired
    private MenuItemDAO menuItemDAO;

    public MenuItem getMenuItem(String id) {
        return this.menuItemDAO.findById(id);
    }

    public MenuItemFull getMenuItemFull(String id) {
        return this.getMenuItemFull(id, 1);
    }

    public MenuItemFull getMenuItemFull(String id, int maxDepth) {
        MenuItem menuItem = this.menuItemDAO.findById(id);
        MenuItemFull menuItemFull = new MenuItemFull(menuItem);
        if (maxDepth == 0) {
            menuItemFull.setItems(new ArrayList());
            return menuItemFull;
        }
        ArrayList<MenuItemFull> menuItemsFull = new ArrayList<MenuItemFull>();
        for (String menuItemString : menuItem.getItems()) {
            menuItemsFull.add(this.getMenuItemFull(menuItemString, maxDepth - 1));
        }
        menuItemFull.setItems(menuItemsFull);
        return menuItemFull;
    }

    public List<MenuItem> getMenuItemsByParent(String parentId, String portalPid) {
        if (portalPid != null) {
            return this.menuItemDAO.findByParentItemIdAndPortalPid(parentId, portalPid);
        }
        return this.menuItemDAO.findByParentItemId(parentId);
    }

    public List<MenuItemFull> getRootMenuItemsFull(String portalPid) {
        List rootMenuItems = this.getMenuItemsByParent(null, portalPid);
        ArrayList<MenuItemFull> rootMenuItemsFull = new ArrayList<MenuItemFull>();
        for (MenuItem rootMenuItem : rootMenuItems) {
            MenuItemFull rootMenuItemFull = new MenuItemFull(rootMenuItem);
            ArrayList<MenuItemFull> childrenMenuItemsFull = new ArrayList<MenuItemFull>();
            for (String childMenuItemString : rootMenuItem.getItems()) {
                childrenMenuItemsFull.add(this.getMenuItemFull(childMenuItemString));
            }
            rootMenuItemFull.setItems(childrenMenuItemsFull);
            rootMenuItemsFull.add(rootMenuItemFull);
        }
        return rootMenuItemsFull;
    }

    public MenuFull getMenuFull(String portalPid) {
        MenuFull menuFull = new MenuFull();
        Menu menu = this.menuDAO.findByPortalPid(portalPid);
        ArrayList<MenuItemFull> featuredMenuItems = new ArrayList<MenuItemFull>();
        ArrayList<MenuItemFull> menuItems = new ArrayList<MenuItemFull>();
        if (menu == null) {
            menuFull.setFeaturedMenuEnabled(true);
            menuFull.setMenuEnabled(true);
        } else {
            for (String menuItemId : menu.getFeaturedMenuItems()) {
                featuredMenuItems.add(this.getFullRootMenuItemById(menuItemId, portalPid, Boolean.valueOf(true)));
            }
            for (String menuItemId : menu.getMenuItems()) {
                menuItems.add(this.getFullRootMenuItemById(menuItemId, portalPid, Boolean.valueOf(false)));
            }
            menuFull.setFeaturedMenuEnabled(menu.getIsFeaturedMenuEnabled());
            menuFull.setMenuEnabled(menu.getIsMenuEnabled());
        }
        menuFull.setPortalPid(portalPid);
        menuFull.setFeaturedMenuItems(featuredMenuItems);
        menuFull.setMenuItems(menuItems);
        return menuFull;
    }

    private MenuItemFull getFullRootMenuItemById(String menuItemId, String portalPid, Boolean isFeatured) {
        MenuItem rootMenuItem = this.menuItemDAO.findById(menuItemId);
        if (rootMenuItem.getIsFeatured() != isFeatured) {
            throw new MismatchingContentException("getFullRootMenuItemById: Menu item should " + (isFeatured != false ? "" : "not ") + "be featured");
        }
        if (!rootMenuItem.getPortalPid().equals(portalPid)) {
            throw new MismatchingContentException("getFullRootMenuItemById: Menu item with id: " + rootMenuItem.getId() + " has portal pid: " + rootMenuItem.getPortalPid() + " instead of " + portalPid);
        }
        if (rootMenuItem.getParentItemId() != null) {
            throw new MismatchingContentException("getFullRootMenuItemById: Menu item should be root (no parentId), but instead parentId: " + rootMenuItem.getParentItemId());
        }
        MenuItemFull rootMenuItemFull = new MenuItemFull(rootMenuItem);
        ArrayList<MenuItemFull> childrenMenuItemsFull = new ArrayList<MenuItemFull>();
        for (String childMenuItemString : rootMenuItem.getItems()) {
            childrenMenuItemsFull.add(this.getMenuItemFull(childMenuItemString));
        }
        rootMenuItemFull.setItems(childrenMenuItemsFull);
        return rootMenuItemFull;
    }

    private MenuItemFull insertMenuItem(MenuItem menuItem, String portalPid) {
        MenuItem parent = null;
        if (menuItem.getParentItemId() != null && !menuItem.getParentItemId().equals("")) {
            parent = this.getMenuItem(menuItem.getParentItemId());
            if (!parent.getPortalPid().equals(portalPid)) {
                throw new MismatchingContentException("insertMenuItem: parent (" + parent.getParentItemId() + ") of MenuItem has portalPid: " + parent.getPortalPid() + " instead of " + portalPid);
            }
        } else {
            menuItem.setParentItemId(null);
        }
        if (menuItem.getItems() == null) {
            ArrayList menuItems = new ArrayList();
            menuItem.setItems(menuItems);
        }
        this.menuItemDAO.save(menuItem);
        if (parent != null) {
            List siblingsOfNew = parent.getItems();
            siblingsOfNew.add(menuItem.getId());
            parent.setItems(siblingsOfNew);
            this.menuItemDAO.save(parent);
        }
        MenuItemFull menuItemFull = new MenuItemFull(menuItem);
        menuItemFull.setItems(new ArrayList());
        return menuItemFull;
    }

    public MenuItemFull insertMenuItemInMenu(MenuItem menuItem, String portalPid) {
        MenuItemFull menuItemFull = this.insertMenuItem(menuItem, portalPid);
        Menu menu = this.menuDAO.findByPortalPid(portalPid);
        if (menu == null) {
            menu = new Menu(portalPid);
        }
        if (menuItem.getIsFeatured().booleanValue() && menuItem.getParentItemId() == null) {
            menu.getFeaturedMenuItems().add(menuItemFull.getId());
        } else if (menuItem.getParentItemId() == null) {
            menu.getMenuItems().add(menuItemFull.getId());
        }
        this.menuDAO.save(menu);
        return menuItemFull;
    }

    public MenuItemFull updateMenuItem(MenuItemFull menuItemFull) {
        MenuItem menuItem = this.getMenuItemByMenuItemFull(menuItemFull);
        MenuItem oldMenuItem = this.getMenuItem(menuItemFull.getId());
        menuItem.setItems(oldMenuItem.getItems());
        menuItem.setParentItemId(oldMenuItem.getParentItemId());
        this.menuItemDAO.save(menuItem);
        menuItemFull = this.getMenuItemFull(menuItem.getId());
        return menuItemFull;
    }

    public MenuItemFull updateMenu(MenuItemFull menuItemFull, String portalPid) {
        menuItemFull = this.updateMenuItem(menuItemFull);
        Menu menu = this.menuDAO.findByPortalPid(portalPid);
        if (menu == null) {
            throw new ContentNotFoundException("updateMenu: No Menu found for portal pid: " + portalPid);
        }
        List featuredMenuItems = menu.getFeaturedMenuItems();
        List menuItems = menu.getMenuItems();
        if (menuItemFull.getIsFeatured().booleanValue() && menuItemFull.getParentItemId() == null && !featuredMenuItems.contains(menuItemFull.getId())) {
            featuredMenuItems.add(menuItemFull.getId());
        } else if ((!menuItemFull.getIsFeatured().booleanValue() || menuItemFull.getParentItemId() != null) && featuredMenuItems.contains(menuItemFull.getId())) {
            featuredMenuItems.remove(menuItemFull.getId());
        } else if (!menuItemFull.getIsFeatured().booleanValue() && menuItemFull.getParentItemId() == null && !menuItems.contains(menuItemFull.getId())) {
            menuItems.add(menuItemFull.getId());
        } else if ((menuItemFull.getIsFeatured().booleanValue() || menuItemFull.getParentItemId() != null) && menuItems.contains(menuItemFull.getId())) {
            menuItems.remove(menuItemFull.getId());
        }
        this.menuDAO.save(menu);
        return menuItemFull;
    }

    public Boolean deleteMenuItem(String id, String portalPid) throws Exception {
        Menu menu = this.menuDAO.findByPortalPid(portalPid);
        if (menu == null) {
            throw new ContentNotFoundException("deleteMenuItem: No Menu found for portal pid: " + portalPid);
        }
        List featuredMenuItems = menu.getFeaturedMenuItems();
        List menuItems = menu.getMenuItems();
        if (featuredMenuItems.contains(id)) {
            featuredMenuItems.remove(id);
        } else if (menuItems.contains(id)) {
            menuItems.remove(id);
        }
        this.menuDAO.save(menu);
        this.log.debug((Object)("delete menu item; " + id));
        ArrayList<String> menuItemsToDelete = new ArrayList<String>();
        menuItemsToDelete.add(id);
        return this.deleteMenuItems(menuItemsToDelete, portalPid);
    }

    public Boolean deleteMenuItems(List<String> menuItems, String portalPid) throws Exception {
        if (menuItems == null) {
            return true;
        }
        for (String id : menuItems) {
            MenuItem menuItem = this.menuItemDAO.findById(id);
            if (!portalPid.equals(menuItem.getPortalPid())) {
                throw new MismatchingContentException("Delete Menu Items: MenuItem with id: " + id + " has portalPid: " + menuItem.getPortalPid() + " instead of " + portalPid);
            }
            this.deleteMenuItems(menuItem.getItems(), portalPid);
            if (menuItem.getParentItemId() != null && !menuItem.getParentItemId().equals("")) {
                MenuItem parent = this.menuItemDAO.findById(menuItem.getParentItemId());
                List siblingsOfDeleted = parent.getItems();
                siblingsOfDeleted.remove(id);
                parent.setItems(siblingsOfDeleted);
                this.menuItemDAO.save(parent);
            }
            this.menuItemDAO.delete(id);
        }
        return true;
    }

    public Boolean deleteMenuByPortalPid(String portalPid) throws Exception {
        Menu menu = this.menuDAO.findByPortalPid(portalPid);
        if (menu != null) {
            this.deleteMenuItems(menu.getMenuItems(), portalPid);
            this.deleteMenuItems(menu.getFeaturedMenuItems(), portalPid);
            this.menuDAO.deleteByPortalPid(portalPid);
        }
        return true;
    }

    public Boolean reorderMenuItems(List<MenuItemFull> menuItemsFull, String portalPid) {
        Menu menu;
        List savedMenuItems;
        List<String> menuItemIds = new ArrayList();
        boolean isFeatured = menuItemsFull.get(0).getIsFeatured();
        String parentId = menuItemsFull.get(0).getParentItemId();
        for (MenuItemFull menuItem : menuItemsFull) {
            if (!portalPid.equals(menuItem.getPortalPid())) {
                throw new MismatchingContentException("reorderMenuItems: MenuItems for reordering have not the same portalPid");
            }
            if (menuItem.getIsFeatured() != isFeatured) {
                throw new MismatchingContentException("reorderMenuItems: MenuItems for reordering have not the same isFeatured");
            }
            if (menuItem.getParentItemId() == null && parentId != null || parentId == null && menuItem.getParentItemId() != null || parentId != null && !menuItem.getParentItemId().equals(parentId)) {
                throw new MismatchingContentException("reorderMenuItems: MenuItems for reordering have not the same parentItemId");
            }
            menuItemIds.add(menuItem.getId());
        }
        if (parentId != null) {
            MenuItem parent = this.menuItemDAO.findById(parentId);
            savedMenuItems = parent.getItems();
            menuItemIds = this.addSavedMenuItems(savedMenuItems, menuItemIds, menuItemsFull);
            parent.setItems(menuItemIds);
            this.menuItemDAO.save(parent);
        } else if (isFeatured) {
            menu = this.menuDAO.findByPortalPid(portalPid);
            savedMenuItems = menu.getFeaturedMenuItems();
            menuItemIds = this.addSavedMenuItems(savedMenuItems, menuItemIds, menuItemsFull);
            menu.setFeaturedMenuItems(menuItemIds);
            this.menuDAO.save(menu);
        } else {
            menu = this.menuDAO.findByPortalPid(portalPid);
            savedMenuItems = menu.getMenuItems();
            menuItemIds = this.addSavedMenuItems(savedMenuItems, menuItemIds, menuItemsFull);
            menu.setMenuItems(menuItemIds);
            this.menuDAO.save(menu);
        }
        return true;
    }

    private List<String> addSavedMenuItems(List<String> savedMenuItems, List<String> menuItemIds, List<MenuItemFull> menuItemsFull) {
        for (String menuId : savedMenuItems) {
            if (menuItemIds.contains(menuId)) continue;
            menuItemIds.add(menuId);
        }
        return menuItemIds;
    }

    private MenuItem getMenuItemByMenuItemFull(MenuItemFull menuItemFull) {
        MenuItem menuItem = new MenuItem();
        menuItem.setId(menuItemFull.getId());
        menuItem.setTitle(menuItemFull.getTitle());
        menuItem.setUrl(menuItemFull.getUrl());
        menuItem.setType(menuItemFull.getType());
        menuItem.setTarget(menuItemFull.getTarget());
        menuItem.setRoute(menuItemFull.getRoute());
        menuItem.setPortalPid(menuItemFull.getPortalPid());
        menuItem.setParentItemId(menuItemFull.getParentItemId());
        menuItem.setIsFeatured(menuItemFull.getIsFeatured());
        List menuItemsFull = menuItemFull.getItems();
        ArrayList<String> menuItems = new ArrayList<String>();
        if (menuItemsFull != null) {
            for (MenuItemFull childMenuItemFull : menuItemsFull) {
                menuItems.add(childMenuItemFull.getId());
            }
        }
        menuItem.setItems(menuItems);
        return menuItem;
    }

    public Menu toggleMenu(String pid, String status, String isFeatured) throws Exception {
        Menu menu = this.menuDAO.findByPortalPid(pid);
        if (isFeatured != null && Boolean.parseBoolean(isFeatured)) {
            menu.setFeaturedMenuEnabled(Boolean.parseBoolean(status));
        } else {
            menu.setMenuEnabled(Boolean.parseBoolean(status));
        }
        return this.menuDAO.save(menu);
    }
}

