/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.rest;

import eu.dnetlib.openaire.rest.UserInfo;
import eu.dnetlib.openaire.rest.inputHandler.UserHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class Authorization {
    private static Logger logger = Logger.getLogger(Authorization.class);
    List<String> registeredRoles = new ArrayList<String>(Arrays.asList("Super Administrator", "Portal Administrator", "Expert - Community", "Expert - Funder", "Curator - Claim", "Curator - Project", "Curator - Community", "Curator - Institution", "Cuthor", "Registered", "User Manager"));
    List<String> adminRoles = new ArrayList<String>(Arrays.asList("Super Administrator", "Curator - Claim", "Portal Administrator"));
    List<String> projectCuratorRoles = new ArrayList<String>(Arrays.asList("Curator - Project"));
    UserHandler userHandler = null;
    String originServer = null;

    public boolean isRegistered(String token) {
        UserInfo userInfo = this.userHandler.getUserInfo(token);
        return this.isRegistered(userInfo);
    }

    public boolean isRegistered(UserInfo userInfo) {
        if (userInfo != null && userInfo.getEdu_person_entitlements() != null) {
            return this.hasRole(userInfo.getEdu_person_entitlements(), this.registeredRoles);
        }
        return false;
    }

    public boolean isAdmin(String token) {
        UserInfo userInfo = this.userHandler.getUserInfo(token);
        return this.isAdmin(userInfo);
    }

    public boolean isAdmin(UserInfo userInfo) {
        if (userInfo != null && userInfo.getEdu_person_entitlements() != null) {
            return this.hasRole(userInfo.getEdu_person_entitlements(), this.adminRoles);
        }
        logger.debug((Object)" User has no Valid UserInfo");
        return false;
    }

    public boolean isProjectCurator(String token) {
        UserInfo userInfo = this.userHandler.getUserInfo(token);
        return this.isProjectCurator(userInfo);
    }

    public boolean isProjectCurator(UserInfo userInfo) {
        if (userInfo != null && userInfo.getEdu_person_entitlements() != null) {
            return this.hasRole(userInfo.getEdu_person_entitlements(), this.projectCuratorRoles);
        }
        return false;
    }

    public boolean hasRole(List<String> givenRoles, List<String> authorizedRoles) {
        logger.debug((Object)("It's  registered with role " + givenRoles));
        for (String gRole : givenRoles) {
            if (authorizedRoles.indexOf(gRole) == -1) continue;
            return true;
        }
        logger.debug((Object)("Not Authorized. Authorized roles are" + authorizedRoles));
        return false;
    }

    public boolean hasValidOrigin(String origin) {
        return origin != null && this.originServer.equals(origin);
    }

    public List<String> getRegisteredRoles() {
        return this.registeredRoles;
    }

    public void setRegisteredRoles(List<String> registeredRoles) {
        this.registeredRoles = registeredRoles;
    }

    public List<String> getAdminRoles() {
        return this.adminRoles;
    }

    public void setAdminRoles(List<String> adminRoles) {
        this.adminRoles = adminRoles;
    }

    public List<String> getProjectCuratorRoles() {
        return this.projectCuratorRoles;
    }

    public void setProjectCuratorRoles(List<String> projectCuratorRoles) {
        this.projectCuratorRoles = projectCuratorRoles;
    }

    public UserHandler getUserHandler() {
        return this.userHandler;
    }

    public void setUserHandler(UserHandler userHandler) {
        this.userHandler = userHandler;
    }

    public String getOriginServer() {
        return this.originServer;
    }

    public void setOriginServer(String originServer) {
        this.originServer = originServer;
    }
}

