/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.rest.inputHandler;

import com.google.gson.Gson;
import eu.dnetlib.openaire.rest.Authorization;
import eu.dnetlib.openaire.rest.UserInfo;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.xml.bind.DatatypeConverter;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class UserHandler {
    private static Logger logger = Logger.getLogger(UserHandler.class);
    String userInfoUrl = null;

    public String getMail(String token) {
        Claims claims = (Claims)Jwts.parser().setSigningKey(DatatypeConverter.parseBase64Binary((String)"my-very-secret")).parseClaimsJws(token).getBody();
        return (String)claims.get((Object)"email");
    }

    public UserInfo getUserInfo(String accessToken) {
        String url = this.userInfoUrl + accessToken;
        URL obj = null;
        String responseStr = null;
        logger.debug((Object)("User info url is " + url));
        try {
            String inputLine;
            obj = new URL(url);
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            logger.debug((Object)("User info response code is: " + con.getResponseCode()));
            if (con.getResponseCode() != 200) {
                return null;
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine).append("\n");
            }
            in.close();
            responseStr = response.toString();
        }
        catch (Exception e) {
            logger.error((Object)"An error occured while trying to fetch user info ", (Throwable)e);
            return null;
        }
        return this.json2UserInfo(responseStr);
    }

    private UserInfo json2UserInfo(String json) {
        logger.debug((Object)("Try to create userInfo class from json: " + json));
        if (json == null) {
            return null;
        }
        BufferedReader br = new BufferedReader(new StringReader(json));
        Gson gson = new Gson();
        UserInfo userInfo = null;
        try {
            userInfo = (UserInfo)gson.fromJson((Reader)br, UserInfo.class);
        }
        catch (Exception e) {
            logger.debug((Object)("Error in parsing json response. Given json is : " + json));
            return null;
        }
        logger.debug((Object)("Original response : " + userInfo.toString()));
        if (userInfo != null && userInfo.getEdu_person_entitlements() != null) {
            for (int i = 0; i < userInfo.getEdu_person_entitlements().size(); ++i) {
                String role = userInfo.getEdu_person_entitlements().get(i);
                role = role.split("urn:mace:openminted.eu:aai.openminted.eu:group:OpenAIRE\\+")[1];
                role = role.replace("+", " ");
                userInfo.getEdu_person_entitlements().set(i, role);
            }
        }
        logger.debug((Object)("After handling roles : " + userInfo.toString()));
        return userInfo;
    }

    public String getUserInfoUrl() {
        return this.userInfoUrl;
    }

    public void setUserInfoUrl(String userInfoUrl) {
        this.userInfoUrl = userInfoUrl;
    }

    public static void main(String[] args) throws IOException {
        BasicConfigurator.configure();
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("eu/dnetlib/openaire/rest/springContext-claims-authorization.xml");
        Authorization authorization = (Authorization)context.getBean(Authorization.class);
        UserHandler userHandler = (UserHandler)context.getBean(UserHandler.class);
        System.out.println("\n\nAdmin Roles " + authorization.getAdminRoles().size() + "   " + authorization.getAdminRoles() + "\n\n\n");
        System.out.println("\n\ngetProjectCuratorRoles Roles " + authorization.getProjectCuratorRoles().size() + "   " + authorization.getProjectCuratorRoles() + "\n\n\n");
        System.out.println("\n\ngetRegisteredRoles Roles " + authorization.getRegisteredRoles().size() + "   " + authorization.getRegisteredRoles() + "\n\n\n");
        System.out.println("\n\nIs Admin::\n" + authorization.isAdmin("eyJraWQiOiJvaWRjIiwiYWxnIjoiUlMyNTYifQ.eyJzdWIiOiIwOTMxNzMwMTMyODMzNjMyQG9wZW5taW50ZWQuZXUiLCJhenAiOiIyNGU4MzE3Ni0xMzEyLTRiYTMtYmMwYi1mZmVlYmVhMTYwM2UiLCJpc3MiOiJodHRwczpcL1wvYWFpLm9wZW5taW50ZWQuZXVcL29pZGNcLyIsImV4cCI6MTQ5ODQ4NTk3NiwiaWF0IjoxNDk4NDcxNTc2LCJqdGkiOiJkMWRlZjc1Yi00MTEyLTRiZDktYTIyNi0wZThhOWI2M2Y3MWQifQ.WVYOb_yO8OaxIIt2jRYEDQBhGGFRDTBw3DgtVV_smuN5yx1ScCj6aehLu3JKPSArme4m2SGF4TEGhpwNJkwhM2WapGtxmtuCmCzYIo_QlC1Yki9hr2OT2rXMcQsJCiKaBSf6pLue6Sn78GMB5yaUTvOQHRgidXGiZXH5lsuZUx15Q6Equ_wzond_rgP9mRheRkTyIFuvvg4PuzmudBc11Ty863vIIQtoWF7_p98zTbHxiNF9lLPwzPZKxDoQ8JeayQEC-jsWVLgxmp-h0jG_Ko5jFVVJeeosqMMucOrs2FT_NKHVYVqB6VVh0C6nOufeiLrNDeMUlDT4dAvKD2zE9w") + "\n\n\n");
    }
}

