/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.rest.security;

import io.jsonwebtoken.ClaimJwtException;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.PrematureJwtException;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.UnsupportedJwtException;
import javax.xml.bind.DatatypeConverter;
import org.apache.log4j.Logger;

public class JWTValidator {
    private static final Logger logger = Logger.getLogger(JWTValidator.class);

    public static boolean isValid(String token) {
        try {
            Claims claims = (Claims)Jwts.parser().setSigningKey(DatatypeConverter.parseBase64Binary((String)"my-very-secret")).parseClaimsJws(token).getBody();
            logger.debug((Object)("Id: " + claims.get((Object)"userId")));
            logger.debug((Object)("Subject: " + claims.getSubject()));
            logger.debug((Object)("Fullname: " + claims.get((Object)"fullname")));
            logger.debug((Object)("Email: " + claims.get((Object)"email")));
            logger.debug((Object)("Role: " + claims.get((Object)"role")));
            logger.debug((Object)("Expiration: " + claims.getExpiration()));
            return true;
        }
        catch (SignatureException e) {
            logger.error((Object)"Either calculating a signature or verifying an existing signature of a JWT failed", (Throwable)e);
            return false;
        }
        catch (PrematureJwtException e) {
            logger.error((Object)"A JWT was accepted before it is allowed to be accessed and must be rejected", (Throwable)e);
            return false;
        }
        catch (ClaimJwtException e) {
            logger.error((Object)"After a validation of a JWT claim failed", (Throwable)e);
            return false;
        }
        catch (MalformedJwtException e) {
            logger.error((Object)"A JWT was not correctly constructed and should be rejected", (Throwable)e);
            return false;
        }
        catch (UnsupportedJwtException e) {
            logger.error((Object)"Receiving a JWT in a particular format/configuration that does not match the format expected by the application", (Throwable)e);
            return false;
        }
    }
}

