/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.rest;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.dnetlib.api.enabling.ISLookUpService;
import eu.dnetlib.api.enabling.ISLookUpServiceException;
import eu.dnetlib.data.claims.migration.ClaimValidationException;
import eu.dnetlib.data.claims.migration.entity.Claim;
import eu.dnetlib.data.claims.migration.handler.ClaimHandler;
import eu.dnetlib.data.claims.migration.handler.DirectIndexHandler;
import eu.dnetlib.data.claims.migration.handler.FetchClaimHandler;
import eu.dnetlib.data.claims.migration.handler.FetchProjectHandler;
import eu.dnetlib.data.claimsDemo.SQLStoreException;
import eu.dnetlib.openaire.rest.Authorization;
import eu.dnetlib.openaire.rest.UserInfo;
import gr.uoa.di.driver.util.ServiceLocator;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.validator.EmailValidator;
import org.apache.log4j.Logger;
import org.json.XML;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/claimsService")
public class HelloWorldService {
    private static final Logger logger = Logger.getLogger(HelloWorldService.class);
    @Autowired
    private FetchClaimHandler fetchClaimHandler = null;
    @Autowired
    private FetchProjectHandler fetchProjectHandler = null;
    @Resource
    private ServiceLocator<ISLookUpService> lookupServiceLocator = null;
    @Autowired
    private ClaimHandler claimHandler = null;
    @Autowired
    private DirectIndexHandler directIndexHandler = null;
    @Autowired
    public Authorization authorization = null;

    @GET
    @Path(value="projects/{projectId}/claims")
    @Produces(value={"application/json"})
    public Response getProjectClaims(@PathParam(value="projectId") String projectId, @DefaultValue(value="0") @QueryParam(value="offset") int offset, @DefaultValue(value="20") @QueryParam(value="limit") int limit, @DefaultValue(value="") @QueryParam(value="keyword") String keyword, @DefaultValue(value="") @QueryParam(value="sortby") String orderby, @DefaultValue(value="true") @QueryParam(value="descending") boolean descending, @DefaultValue(value="") @QueryParam(value="types") String types, @HeaderParam(value="X-XSRF-TOKEN") String token, @CookieParam(value="AccessToken") String cookie, @Context HttpServletRequest request) {
        logger.debug((Object)("header \"X-XSRF-TOKEN\" has value " + token));
        logger.debug((Object)("cookie  \"AccessToken\" has value  " + cookie));
        if (token == null || token.isEmpty() || cookie == null || cookie.isEmpty() || !cookie.equals(token)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. Maybe you are not registered.")).type("application/json").build();
        }
        if (this.authorization.isAdmin(token)) {
            int total = -1;
            if (projectId == null || projectId.isEmpty()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.compose400Message("Project id cannot be empty.")).type("application/json").build();
            }
            List claims = null;
            ArrayList<String> listTypes = new ArrayList<String>();
            String[] types_array = types.split(",");
            for (int i = 0; i < types_array.length; ++i) {
                if (types_array[i].length() <= 0) continue;
                listTypes.add(types_array[i]);
            }
            try {
                claims = this.fetchClaimHandler.fetchClaimsByProject(projectId, Integer.valueOf(limit), Integer.valueOf(offset), keyword, orderby, descending, listTypes, false);
                total = this.fetchClaimHandler.countClaimsByProject(projectId, keyword, listTypes);
            }
            catch (SQLStoreException | Exception e) {
                logger.error((Object)("Could not fetch claims for project with id " + projectId), e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.compose500Message("Fail to fetch claims for projects with id " + projectId + ".", e)).type("application/json").build();
            }
            return Response.status((int)200).entity((Object)this.composeDataResponse(request, claims, total, offset, limit)).build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access")).type("application/json").build();
    }

    @GET
    @Path(value="project/claims")
    @Produces(value={"application/json"})
    public Response getProjectClaimsByToken(@QueryParam(value="projectToken") String projectToken, @DefaultValue(value="-1") @QueryParam(value="offset") int offset, @DefaultValue(value="-1") @QueryParam(value="limit") int limit, @DefaultValue(value="") @QueryParam(value="keyword") String keyword, @DefaultValue(value="") @QueryParam(value="sortby") String orderby, @DefaultValue(value="true") @QueryParam(value="descending") boolean descending, @DefaultValue(value="") @QueryParam(value="types") String types, @HeaderParam(value="X-XSRF-TOKEN") String token, @CookieParam(value="AccessToken") String cookie, @Context HttpServletRequest request) {
        logger.debug((Object)("header \"X-XSRF-TOKEN\" has value " + token));
        logger.debug((Object)("cookie  \"AccessToken\" has value  " + cookie));
        if (token == null || token.isEmpty() || cookie == null || cookie.isEmpty() || !cookie.equals(token)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. Maybe you are not registered.")).type("application/json").build();
        }
        UserInfo userInfo = this.authorization.getUserHandler().getUserInfo(token);
        if (this.authorization.isProjectCurator(userInfo)) {
            String userMail = userInfo.getEmail();
            int total = -1;
            if (projectToken == null || projectToken.isEmpty()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.compose400Message("Project token cannot be empty.")).type("application/json").build();
            }
            List claims = null;
            ArrayList<String> listTypes = new ArrayList<String>();
            String[] types_array = types.split(",");
            for (int i = 0; i < types_array.length; ++i) {
                if (types_array[i].length() <= 0) continue;
                listTypes.add(types_array[i]);
            }
            try {
                String projectId = this.fetchProjectHandler.fetchProjectIdByToken(projectToken, userMail);
                if (projectId == null) {
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access")).type("application/json").build();
                }
                claims = offset == -1 && limit == -1 ? this.fetchClaimHandler.fetchClaimsByProject(projectId, null, null, keyword, orderby, descending, listTypes, true) : this.fetchClaimHandler.fetchClaimsByProject(projectId, Integer.valueOf(limit), Integer.valueOf(offset), keyword, orderby, descending, listTypes, true);
                total = this.fetchClaimHandler.countClaimsByProject(projectId, keyword, listTypes);
                return Response.status((int)200).entity((Object)this.composeDataResponse(request, claims, total, offset, limit)).build();
            }
            catch (SQLStoreException | Exception e) {
                logger.error((Object)("Could not fetch claims for project token " + projectToken), e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.compose500Message("Fail to fetch claims for projects with token " + projectToken + ".", e)).type("application/json").build();
            }
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access")).type("application/json").build();
    }

    @GET
    @Path(value="/contexts/{contextId}/claims")
    @Produces(value={"application/json"})
    public Response getContextClaims(@PathParam(value="contextId") String contextId, @DefaultValue(value="0") @QueryParam(value="offset") int offset, @DefaultValue(value="20") @QueryParam(value="limit") int limit, @DefaultValue(value="") @QueryParam(value="keyword") String keyword, @DefaultValue(value="") @QueryParam(value="sortby") String orderby, @DefaultValue(value="true") @QueryParam(value="descending") boolean descending, @DefaultValue(value="") @QueryParam(value="types") String types, @HeaderParam(value="X-XSRF-TOKEN") String token, @CookieParam(value="AccessToken") String cookie, @Context HttpServletRequest request) {
        logger.debug((Object)("header \"X-XSRF-TOKEN\" has value " + token));
        logger.debug((Object)("cookie  \"AccessToken\" has value  " + cookie));
        if (token == null || token.isEmpty() || cookie == null || cookie.isEmpty() || !cookie.equals(token)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. Maybe you are not registered.")).type("application/json").build();
        }
        logger.debug((Object)("Calling API for context with token " + token));
        if (this.authorization.isAdmin(token)) {
            int total = -1;
            if (contextId == null || contextId.isEmpty()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.compose400Message("Context id cannot be empty.")).type("application/json").build();
            }
            List claims = null;
            ArrayList<String> listTypes = new ArrayList<String>();
            String[] types_array = types.split(",");
            for (int i = 0; i < types_array.length; ++i) {
                if (types_array[i].length() <= 0) continue;
                listTypes.add(types_array[i]);
            }
            try {
                claims = this.fetchClaimHandler.fetchClaimsByContext(contextId, Integer.valueOf(limit), Integer.valueOf(offset), keyword, orderby, descending, listTypes, false);
                total = this.fetchClaimHandler.countClaimsByContext(contextId, keyword, listTypes);
            }
            catch (SQLStoreException | Exception e) {
                logger.error((Object)("Could not fetch claims for context with id " + contextId), e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.compose500Message("Fail to fetch claims for context with id " + contextId + ".", e)).type("application/json").build();
            }
            return Response.status((int)200).entity((Object)this.composeDataResponse(request, claims, total, offset, limit)).build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access")).type("application/json").build();
    }

    @GET
    @Path(value="/results/{resultId}/claims")
    @Produces(value={"application/json"})
    public Response getResultClaims(@PathParam(value="resultId") String resultId, @DefaultValue(value="0") @QueryParam(value="offset") int offset, @DefaultValue(value="20") @QueryParam(value="limit") int limit, @DefaultValue(value="") @QueryParam(value="keyword") String keyword, @DefaultValue(value="") @QueryParam(value="sortby") String orderby, @DefaultValue(value="true") @QueryParam(value="descending") boolean descending, @DefaultValue(value="") @QueryParam(value="types") String types, @HeaderParam(value="X-XSRF-TOKEN") String token, @CookieParam(value="AccessToken") String cookie, @Context HttpServletRequest request) {
        logger.debug((Object)("header \"X-XSRF-TOKEN\" has value " + token));
        logger.debug((Object)("cookie  \"AccessToken\" has value  " + cookie));
        if (token == null || token.isEmpty() || cookie == null || cookie.isEmpty() || !cookie.equals(token)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. Maybe you are not registered.")).type("application/json").build();
        }
        if (this.authorization.isAdmin(token)) {
            int total = -1;
            if (resultId == null || resultId.isEmpty()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.compose400Message("Context id cannot be empty.")).type("application/json").build();
            }
            List claims = null;
            ArrayList<String> listTypes = new ArrayList<String>();
            String[] types_array = types.split(",");
            for (int i = 0; i < types_array.length; ++i) {
                if (types_array[i].length() <= 0) continue;
                listTypes.add(types_array[i]);
            }
            try {
                claims = this.fetchClaimHandler.fetchClaimsByResult(resultId, Integer.valueOf(limit), Integer.valueOf(offset), keyword, orderby, descending, listTypes, false);
                total = this.fetchClaimHandler.countClaimsByResult(resultId, keyword, listTypes);
            }
            catch (SQLStoreException | Exception e) {
                logger.error((Object)("Could not fetch claims for result with id " + resultId), e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.compose500Message("Fail to fetch claims for result with id " + resultId + ".", e)).type("application/json").build();
            }
            return Response.status((int)200).entity((Object)this.composeDataResponse(request, claims, total, offset, limit)).build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access")).type("application/json").build();
    }

    @GET
    @Path(value="/users/claims")
    @Produces(value={"application/json"})
    public Response getUserClaims(@DefaultValue(value="0") @QueryParam(value="offset") int offset, @DefaultValue(value="20") @QueryParam(value="limit") int limit, @DefaultValue(value="") @QueryParam(value="keyword") String keyword, @DefaultValue(value="") @QueryParam(value="sortby") String orderby, @DefaultValue(value="true") @QueryParam(value="descending") boolean descending, @DefaultValue(value="") @QueryParam(value="types") String types, @HeaderParam(value="X-XSRF-TOKEN") String token, @CookieParam(value="AccessToken") String cookie, @Context HttpServletRequest request) {
        logger.debug((Object)("header \"X-XSRF-TOKEN\" has value " + token));
        logger.debug((Object)("cookie  \"AccessToken\" has value  " + cookie));
        if (token == null || token.isEmpty() || cookie == null || cookie.isEmpty() || !cookie.equals(token)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. Maybe you are not registered.")).type("application/json").build();
        }
        UserInfo userInfo = this.authorization.getUserHandler().getUserInfo(token);
        if (this.authorization.isRegistered(userInfo)) {
            String userMail = userInfo.getEmail();
            logger.debug((Object)"User is registerd ");
            int total = -1;
            EmailValidator emailValidator = EmailValidator.getInstance();
            if (userMail == null || userMail.isEmpty()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.compose400Message("User e-mail cannot be empty.")).type("application/json").build();
            }
            if (!emailValidator.isValid(userMail)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.compose400Message("User e-mail is not valid.")).type("application/json").build();
            }
            List claims = null;
            ArrayList<String> listTypes = new ArrayList<String>();
            String[] types_array = types.split(",");
            for (int i = 0; i < types_array.length; ++i) {
                if (types_array[i].length() <= 0) continue;
                listTypes.add(types_array[i]);
            }
            try {
                logger.debug((Object)"About to fetch claims");
                claims = this.fetchClaimHandler.fetchClaimsByUser(userMail, Integer.valueOf(limit), Integer.valueOf(offset), keyword, orderby, descending, listTypes, false);
                total = this.fetchClaimHandler.countClaimsByUser(userMail, keyword, listTypes);
            }
            catch (SQLStoreException | Exception e) {
                logger.error((Object)("Could not fetch claims for result with id " + userMail), e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.compose500Message("Fail to fetch claims for user with e-mail " + userMail + ".", e)).type("application/json").build();
            }
            return Response.status((int)200).entity((Object)this.composeDataResponse(request, claims, total, offset, limit)).build();
        }
        logger.debug((Object)"User is *NOT* registerd ");
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. You are not registered.")).type("application/json").build();
    }

    @GET
    @Path(value="/claims/{claimId}")
    @Produces(value={"application/json"})
    public Response getClaimsById(@PathParam(value="claimId") String claimId, @DefaultValue(value="0") @QueryParam(value="offset") int offset, @DefaultValue(value="20") @QueryParam(value="limit") int limit, @HeaderParam(value="X-XSRF-TOKEN") String token, @CookieParam(value="AccessToken") String cookie, @Context HttpServletRequest request) {
        logger.debug((Object)("header \"X-XSRF-TOKEN\" has value " + token));
        logger.debug((Object)("cookie  \"AccessToken\" has value  " + cookie));
        if (token == null || token.isEmpty() || cookie == null || cookie.isEmpty() || !cookie.equals(token)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. Maybe you are not registered.")).type("application/json").build();
        }
        if (this.authorization.isRegistered(token)) {
            List claims = null;
            int total = -1;
            if (claimId == null || claimId.isEmpty()) {
                try {
                    claims = this.fetchClaimHandler.fetchAllClaims(Integer.valueOf(limit), Integer.valueOf(offset), false);
                    total = this.fetchClaimHandler.countAllClaims("", new ArrayList());
                    return Response.status((int)200).entity((Object)this.composeDataResponse(request, claims, total, offset, limit)).type("application/json").build();
                }
                catch (SQLStoreException | Exception e) {
                    logger.error((Object)"Could not fetch claims.", e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.compose500Message("Fail to fetch claims.", e)).type("application/json").build();
                }
            }
            try {
                Claim claim = this.fetchClaimHandler.fetchClaimById(claimId, false);
                if (claim == null) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.compose404Message("Cannot find claim with id " + claimId + ".")).type("application/json").build();
                }
                return Response.status((int)200).entity((Object)this.composeDataResponse(claim)).build();
            }
            catch (SQLStoreException | Exception e) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.compose500Message("Fail to fetch claim with id " + claimId + " id.", e)).type("application/json").build();
            }
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. You are not registered.")).type("application/json").build();
    }

    @GET
    @Path(value="/claims")
    @Produces(value={"application/json"})
    public Response getAllClaims(@DefaultValue(value="0") @QueryParam(value="offset") int offset, @DefaultValue(value="20") @QueryParam(value="limit") int limit, @DefaultValue(value="") @QueryParam(value="keyword") String keyword, @DefaultValue(value="date") @QueryParam(value="sortby") String orderby, @DefaultValue(value="true") @QueryParam(value="descending") boolean descending, @DefaultValue(value="") @QueryParam(value="types") String types, @HeaderParam(value="X-XSRF-TOKEN") String token, @HeaderParam(value="Origin") String origin, @CookieParam(value="AccessToken") String cookie, @Context HttpServletRequest request) {
        logger.debug((Object)("header \"X-XSRF-TOKEN\" has value " + token));
        logger.debug((Object)("cookie  \"AccessToken\" has value  " + cookie));
        logger.debug((Object)("Header  \"Origin\" has value  " + origin));
        if (token == null || token.isEmpty() || cookie == null || cookie.isEmpty() || !cookie.equals(token)) {
            logger.debug((Object)"User is not  authorized - Eroor 403");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. Maybe you are not registered.")).type("application/json").build();
        }
        if (this.authorization.isAdmin(token)) {
            logger.debug((Object)"User is authorized ! !");
            List claims = null;
            ArrayList<String> listTypes = new ArrayList<String>();
            String[] types_array = types.split(",");
            for (int i = 0; i < types_array.length; ++i) {
                if (types_array[i].length() <= 0) continue;
                listTypes.add(types_array[i]);
            }
            logger.debug((Object)("Types: " + ((Object)listTypes).toString()));
            int total = -1;
            try {
                claims = this.fetchClaimHandler.fetchAllClaims(Integer.valueOf(limit), Integer.valueOf(offset), keyword, orderby, descending, listTypes, false);
                total = this.fetchClaimHandler.countAllClaims(keyword, listTypes);
                return Response.status((int)200).entity((Object)this.composeDataResponse(request, claims, total, offset, limit)).build();
            }
            catch (SQLStoreException | Exception e) {
                logger.error((Object)"Could not fetch claims.", e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.compose500Message("Fail to fetch claims.", e)).type("application/json").build();
            }
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access")).type("application/json").build();
    }

    @DELETE
    @Path(value="/claims/bulk")
    @Produces(value={"application/json"})
    public Response deleteBulkClaims(@QueryParam(value="claimId") List<String> claimIds, @HeaderParam(value="X-XSRF-TOKEN") String token, @HeaderParam(value="Origin") String origin, @CookieParam(value="AccessToken") String cookie) {
        logger.debug((Object)("header \"X-XSRF-TOKEN\" has value " + token));
        logger.debug((Object)("cookie  \"AccessToken\" has value  " + cookie));
        if (token == null || token.isEmpty() || cookie == null || cookie.isEmpty() || !cookie.equals(token) || !this.authorization.hasValidOrigin(origin)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. Maybe you are not registered.")).type("application/json").build();
        }
        ArrayList<String> deletedIds = new ArrayList<String>();
        ArrayList<String> notFoundIds = new ArrayList<String>();
        if (claimIds == null || claimIds.size() == 0) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.compose404BulkDeleteMessage("Claim ids cannot be empty.", deletedIds, notFoundIds)).type("application/json").build();
        }
        logger.debug((Object)("Trying to delete claims with ids: " + claimIds.toString() + "."));
        for (String claimId : claimIds) {
            try {
                if (this.authorization.isRegistered(token)) {
                    if (this.authorization.isAdmin(token) || this.authorization.getUserHandler().getMail(token).equals(this.fetchClaimHandler.fetchClaimById(claimId, false).getUserMail())) {
                        if (this.claimHandler.deleteClaim(claimId)) {
                            deletedIds.add(claimId);
                            continue;
                        }
                        notFoundIds.add(claimId);
                        continue;
                    }
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to delete.")).type("application/json").build();
                }
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. Maybe you are not registered.")).type("application/json").build();
            }
            catch (SQLStoreException | Exception e) {
                logger.error((Object)("Fail to delete claim with id " + claimId + "."), e);
                notFoundIds.add(claimId);
            }
        }
        logger.debug((Object)("Successfully deleted " + deletedIds.size() + " from " + claimIds.size() + ". Deleted claims with ids: " + deletedIds.toString() + "."));
        if (claimIds.size() == notFoundIds.size()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.compose404BulkDeleteMessage("Claim ids cannot be empty.", deletedIds, notFoundIds)).type("application/json").build();
        }
        if (claimIds.size() == notFoundIds.size()) {
            return Response.status((int)204).entity((Object)this.compose204BulkDeleteMessage(deletedIds, notFoundIds)).type("application/json").build();
        }
        return Response.status((int)204).entity((Object)this.compose204BulkDeleteMessage(deletedIds, notFoundIds)).type("application/json").build();
    }

    @POST
    @Path(value="/claims")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response addClaim(String input, @Context HttpServletRequest request, @HeaderParam(value="X-XSRF-TOKEN") String token, @HeaderParam(value="Origin") String origin, @CookieParam(value="AccessToken") String cookie) {
        logger.debug((Object)("header \"X-XSRF-TOKEN\" has value " + token));
        logger.debug((Object)("cookie  \"AccessToken\" has value  " + cookie));
        if (token == null || token.isEmpty() || cookie == null || cookie.isEmpty() || !cookie.equals(token) || !this.authorization.hasValidOrigin(origin)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. Maybe you are not registered.")).type("application/json").build();
        }
        UserInfo userInfo = this.authorization.getUserHandler().getUserInfo(token);
        if (this.authorization.isRegistered(userInfo)) {
            JsonObject jsonObject = new JsonParser().parse(input).getAsJsonObject();
            String claimedBy = userInfo.getEmail();
            logger.info((Object)("claimedBy " + claimedBy));
            String sourceId = jsonObject.get("sourceId").getAsString();
            logger.info((Object)("sourceId " + sourceId));
            String sourceType = jsonObject.get("sourceType").getAsString();
            logger.info((Object)("sourceType " + sourceType));
            String sourceCollectedFrom = jsonObject.get("sourceCollectedFrom").getAsString();
            logger.info((Object)("sourceCollectedFrom " + sourceCollectedFrom));
            String sourceAccessRights = jsonObject.get("sourceAccessRights").getAsString();
            logger.info((Object)("sourceAccessRights " + sourceAccessRights));
            String sourceEmbargoEndDate = jsonObject.get("sourceEmbargoEndDate").getAsString();
            sourceEmbargoEndDate = sourceEmbargoEndDate != null && sourceEmbargoEndDate.equals("") ? null : sourceEmbargoEndDate;
            logger.info((Object)("sourceEmbargoEndDate " + sourceEmbargoEndDate));
            String targetId = jsonObject.get("targetId").getAsString();
            logger.info((Object)("targetId " + targetId));
            String targetType = jsonObject.get("targetType").getAsString();
            logger.info((Object)("targetType " + targetType));
            String targetCollectedFrom = jsonObject.get("targetCollectedFrom").getAsString();
            logger.info((Object)("targetCollectedFrom " + targetCollectedFrom));
            String targetAccessRights = jsonObject.get("targetAccessRights").getAsString();
            logger.info((Object)("targetAccessRights " + targetAccessRights));
            String targetEmbargoEndDate = jsonObject.get("targetEmbargoEndDate").getAsString();
            targetEmbargoEndDate = targetEmbargoEndDate != null && targetEmbargoEndDate.equals("") ? null : targetEmbargoEndDate;
            logger.info((Object)("targetEmbargoEndDate " + targetEmbargoEndDate));
            EmailValidator emailValidator = EmailValidator.getInstance();
            if (!emailValidator.isValid(claimedBy)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.compose400Message("User e-mail is invalid.")).type("application/json").build();
            }
            try {
                String claimId = this.claimHandler.buildAndInsertClaim(claimedBy, sourceType, sourceId, sourceCollectedFrom, sourceAccessRights, sourceEmbargoEndDate, targetType, targetId, targetCollectedFrom, targetAccessRights, targetEmbargoEndDate);
                return Response.status((int)200).entity((Object)this.compose201PostMessage(request, claimId)).type("application/json").build();
            }
            catch (ClaimValidationException ve) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.compose400Message("The given ids are wrong.", (Exception)((Object)ve))).type("application/json").build();
            }
            catch (SQLStoreException | Exception e) {
                logger.error((Object)"Fail to add new claim.", e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.compose500Message("Fail to add new claim.", e)).type("application/json").build();
            }
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access.")).type("application/json").build();
    }

    @POST
    @Path(value="/claims/bulk")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response addBulkClaims(String input, @Context HttpServletRequest request, @HeaderParam(value="X-XSRF-TOKEN") String token, @HeaderParam(value="Origin") String origin, @CookieParam(value="AccessToken") String cookie) {
        logger.debug((Object)("header \"X-XSRF-TOKEN\" has value " + token));
        logger.debug((Object)("cookie  \"AccessToken\" has value  " + cookie));
        if (token == null || token.isEmpty() || cookie == null || cookie.isEmpty() || !cookie.equals(token) || !this.authorization.hasValidOrigin(origin)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. Maybe you are not registered.")).type("application/json").build();
        }
        UserInfo userInfo = this.authorization.getUserHandler().getUserInfo(token);
        if (this.authorization.isRegistered(userInfo)) {
            ArrayList<String> insertedIds = new ArrayList<String>();
            JsonArray errorInClaims = new JsonArray();
            int code200 = 0;
            int code400 = 0;
            int code500 = 0;
            JsonArray jsonArray = new JsonParser().parse(input).getAsJsonArray();
            for (JsonElement je : jsonArray) {
                JsonObject jsonObject = je.getAsJsonObject();
                logger.info((Object)("targetId " + jsonObject.toString()));
                String claimedBy = userInfo.getEmail();
                logger.info((Object)("claimedBy " + claimedBy));
                String sourceId = jsonObject.get("sourceId").getAsString();
                logger.info((Object)("sourceId " + sourceId));
                String sourceType = jsonObject.get("sourceType").getAsString();
                logger.info((Object)("sourceType " + sourceType));
                String sourceCollectedFrom = jsonObject.get("sourceCollectedFrom").getAsString();
                logger.info((Object)("sourceCollectedFrom " + sourceCollectedFrom));
                String sourceAccessRights = jsonObject.get("sourceAccessRights").getAsString();
                logger.info((Object)("sourceAccessRights " + sourceAccessRights));
                String sourceEmbargoEndDate = jsonObject.get("sourceEmbargoEndDate").getAsString();
                sourceEmbargoEndDate = sourceEmbargoEndDate != null && sourceEmbargoEndDate.equals("") ? null : sourceEmbargoEndDate;
                logger.info((Object)("sourceEmbargoEndDate " + sourceEmbargoEndDate));
                String targetId = jsonObject.get("targetId").getAsString();
                logger.info((Object)("targetId " + targetId));
                String targetType = jsonObject.get("targetType").getAsString();
                logger.info((Object)("targetType " + targetType));
                String targetCollectedFrom = jsonObject.get("targetCollectedFrom").getAsString();
                logger.info((Object)("targetCollectedFrom " + targetCollectedFrom));
                String targetAccessRights = jsonObject.get("targetAccessRights").getAsString();
                logger.info((Object)("targetAccessRights " + targetAccessRights));
                String targetEmbargoEndDate = jsonObject.get("targetEmbargoEndDate").getAsString();
                targetEmbargoEndDate = targetEmbargoEndDate != null && targetEmbargoEndDate.equals("") ? null : targetEmbargoEndDate;
                logger.info((Object)("targetEmbargoEndDate " + targetEmbargoEndDate));
                EmailValidator emailValidator = EmailValidator.getInstance();
                if (!emailValidator.isValid(claimedBy)) {
                    jsonObject.addProperty("error", "user");
                    ++code400;
                    errorInClaims.add((JsonElement)jsonObject);
                }
                try {
                    String claimId = this.claimHandler.buildAndInsertClaim(claimedBy, sourceType, sourceId, sourceCollectedFrom, sourceAccessRights, sourceEmbargoEndDate, targetType, targetId, targetCollectedFrom, targetAccessRights, targetEmbargoEndDate);
                    insertedIds.add(claimId);
                    ++code200;
                }
                catch (ClaimValidationException ve) {
                    jsonObject.addProperty("error", "validation");
                    errorInClaims.add((JsonElement)jsonObject);
                    ++code400;
                }
                catch (SQLStoreException | Exception e) {
                    jsonObject.addProperty("error", "insertion");
                    errorInClaims.add((JsonElement)jsonObject);
                    ++code500;
                }
            }
            if (jsonArray.size() == code500) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.compose500BulkInsertMessage("Fail to add new claim.", insertedIds, errorInClaims)).type("application/json").build();
            }
            if (code200 > 0) {
                return Response.status((int)200).entity((Object)this.compose201BulkInsertMessage(insertedIds, errorInClaims)).type("application/json").build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.compose400BulkInsertMessage("The given ids are wrong.", insertedIds, errorInClaims)).type("application/json").build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. You are not registered.")).type("application/json").build();
    }

    @POST
    @Path(value="/curate/bulk")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response curateBulkClaims(String input, @Context HttpServletRequest request, @HeaderParam(value="X-XSRF-TOKEN") String token, @HeaderParam(value="Origin") String origin, @CookieParam(value="AccessToken") String cookie) {
        logger.debug((Object)("header \"X-XSRF-TOKEN\" has value " + token));
        logger.debug((Object)("cookie  \"AccessToken\" has value  " + cookie));
        if (token == null || token.isEmpty() || cookie == null || cookie.isEmpty() || !cookie.equals(token) || !this.authorization.hasValidOrigin(origin)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. Maybe you are not registered.")).type("application/json").build();
        }
        if (this.authorization.isRegistered(token)) {
            ArrayList<String> insertedIds = new ArrayList<String>();
            JsonArray errorInClaims = new JsonArray();
            int code200 = 0;
            int code400 = 0;
            int code500 = 0;
            JsonArray jsonArray = new JsonParser().parse(input).getAsJsonArray();
            String curatedBy = this.authorization.getUserHandler().getMail(token);
            for (JsonElement je : jsonArray) {
                JsonObject jsonObject = je.getAsJsonObject();
                String id = jsonObject.get("id").getAsString();
                logger.info((Object)("id " + id));
                Boolean approved = jsonObject.get("approved").getAsBoolean();
                logger.info((Object)("approved " + approved));
                EmailValidator emailValidator = EmailValidator.getInstance();
                if (!emailValidator.isValid(curatedBy)) {
                    jsonObject.addProperty("error", "user");
                    ++code400;
                    errorInClaims.add((JsonElement)jsonObject);
                }
                try {
                    this.claimHandler.updateClaimCurationInfo(curatedBy, id, approved.booleanValue());
                    insertedIds.add(id);
                    ++code200;
                }
                catch (SQLStoreException | Exception e) {
                    jsonObject.addProperty("error", "insertion");
                    errorInClaims.add((JsonElement)jsonObject);
                    ++code500;
                }
            }
            if (jsonArray.size() == code500) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.compose500BulkInsertMessage("Fail to update claims.", insertedIds, errorInClaims)).type("application/json").build();
            }
            if (code200 > 0) {
                return Response.status((int)200).entity((Object)this.compose201BulkInsertMessage(insertedIds, errorInClaims)).type("application/json").build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.compose400BulkInsertMessage("The given ids are wrong.", insertedIds, errorInClaims)).type("application/json").build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. You are not registered.")).type("application/json").build();
    }

    @POST
    @Path(value="/feed/bulk")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response feedBulkRecords(String input, @Context HttpServletRequest request, @HeaderParam(value="X-XSRF-TOKEN") String token, @HeaderParam(value="Origin") String origin, @CookieParam(value="AccessToken") String cookie) {
        logger.debug((Object)("header \"X-XSRF-TOKEN\" has value " + token));
        logger.debug((Object)("cookie  \"AccessToken\" has value  " + cookie));
        if (token == null || token.isEmpty() || cookie == null || cookie.isEmpty() || !cookie.equals(token) || !this.authorization.hasValidOrigin(origin)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. Maybe you are not registered.")).type("application/json").build();
        }
        if (this.authorization.isRegistered(token)) {
            ArrayList<String> insertedIds = new ArrayList<String>();
            JsonArray errorInClaims = new JsonArray();
            int code200 = 0;
            int code400 = 0;
            int code500 = 0;
            JsonArray jsonArray = new JsonParser().parse(input).getAsJsonArray();
            for (JsonElement je : jsonArray) {
                JsonObject jsonObject = je.getAsJsonObject();
                Boolean inserted = this.directIndexHandler.insertRecord(new Gson().toJson(jsonObject.get("record")));
                if (inserted.booleanValue()) {
                    insertedIds.add(jsonObject.get("id").getAsString());
                    ++code200;
                    continue;
                }
                errorInClaims.add(jsonObject.get("id").getAsString());
                ++code400;
            }
            if (jsonArray.size() == code500) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.compose500BulkInsertMessage("Fail to add new claim.", insertedIds, errorInClaims)).type("application/json").build();
            }
            if (code200 > 0) {
                return Response.status((int)200).entity((Object)this.compose201BulkInsertMessage(insertedIds, errorInClaims)).type("application/json").build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.compose400BulkInsertMessage("The given ids are wrong.", insertedIds, errorInClaims)).type("application/json").build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. You are not registered.")).type("application/json").build();
    }

    @Path(value="/communities")
    @GET
    @Produces(value={"application/json"})
    public Response fetchCommunities(@HeaderParam(value="X-XSRF-TOKEN") String token, @CookieParam(value="AccessToken") String cookie) throws ISLookUpServiceException {
        logger.debug((Object)("header \"X-XSRF-TOKEN\" has value " + token));
        logger.debug((Object)("cookie  \"AccessToken\" has value  " + cookie));
        if (token == null || token.isEmpty() || cookie == null || cookie.isEmpty() || !cookie.equals(token)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. Maybe you are not registered.")).type("application/json").build();
        }
        if (this.authorization.isRegistered(token)) {
            List communities = ((ISLookUpService)this.lookupServiceLocator.getService()).quickSearchProfile("for $x in collection('/db/DRIVER/ContextDSResources/ContextDSResourceType')  \n                where $x//context[@type='community']//category[@claim='true'] \n            return <communities>{$x//context/@id}{$x//context/@label}</communities>");
            return Response.status((int)200).entity((Object)this.composeDataResponse(this.xml2Json(communities))).type("application/json").build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. You are not registered.")).type("application/json").build();
    }

    @Path(value="/communities/{communityid}/categories")
    @GET
    @Produces(value={"application/json"})
    public Response fetchCommunityCategories(@PathParam(value="communityid") String communityid, @HeaderParam(value="X-XSRF-TOKEN") String token, @CookieParam(value="AccessToken") String cookie) throws ISLookUpServiceException {
        logger.debug((Object)("header \"X-XSRF-TOKEN\" has value " + token));
        logger.debug((Object)("cookie  \"AccessToken\" has value  " + cookie));
        if (token == null || token.isEmpty() || cookie == null || cookie.isEmpty() || !cookie.equals(token)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. Maybe you are not registered.")).type("application/json").build();
        }
        if (this.authorization.isRegistered(token)) {
            List categories = ((ISLookUpService)this.lookupServiceLocator.getService()).quickSearchProfile("for $x in collection('/db/DRIVER/ContextDSResources/ContextDSResourceType')//context[@id='" + communityid + "']//category[@claim='true']\nreturn <category>{$x/@id}{$x/@label}</category>");
            logger.info((Object)("for $x in collection('/db/DRIVER/ContextDSResources/ContextDSResourceType')//context[@id='" + communityid + "']//category[@claim='true']\nreturn <category>{$x/@id}{$x/@label}</category>"));
            if (categories == null || categories.isEmpty()) {
                return Response.status((int)404).entity((Object)this.compose404Message("There are no categories for community with id " + communityid)).type("application/json").build();
            }
            this.xml2Json(categories);
            return Response.status((int)200).entity((Object)this.composeDataResponse(this.xml2Json(categories))).type("application/json").build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. You are not registered.")).type("application/json").build();
    }

    @Path(value="/categories/{categoryid}/concepts")
    @GET
    @Produces(value={"application/json"})
    public Response fetchCategoryConcepts(@PathParam(value="categoryid") String categoryid, @HeaderParam(value="X-XSRF-TOKEN") String token, @CookieParam(value="AccessToken") String cookie) throws ISLookUpServiceException {
        logger.debug((Object)("header \"X-XSRF-TOKEN\" has value " + token));
        logger.debug((Object)("cookie  \"AccessToken\" has value  " + cookie));
        if (token == null || token.isEmpty() || cookie == null || cookie.isEmpty() || !cookie.equals(token)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. Maybe you are not registered.")).type("application/json").build();
        }
        if (this.authorization.isRegistered(token)) {
            List concepts = ((ISLookUpService)this.lookupServiceLocator.getService()).quickSearchProfile("for $x in collection('/db/DRIVER/ContextDSResources/ContextDSResourceType') return $x//category[@id='" + categoryid + "']//concept");
            if (concepts == null || concepts.isEmpty()) {
                return Response.status((int)404).entity((Object)this.compose404Message("There are no concepts for category with id " + categoryid)).type("application/json").build();
            }
            return Response.status((int)200).entity((Object)this.composeDataResponse(this.xml2Json(concepts))).type("application/json").build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. You are not registered.")).type("application/json").build();
    }

    private String xml2Json(List<String> input) {
        StringBuilder builder = new StringBuilder();
        for (String category : input) {
            builder.append(category);
        }
        return builder.toString();
    }

    private String compose400Message(String message) {
        return "{ \"status\" : \"error\", \"code\" : \"400\", \"message\" : \"  " + message + " \" }";
    }

    private String compose400Message(String message, Exception exception) {
        return "{ \"status\" : \"error\", \"code\" : \"400\", \"message\" : \"  " + message + "\", \"description\" : \"" + exception.getMessage() + "\" }";
    }

    private String compose403Message(String message) {
        return "{ \"status\" : \"error\", \"code\" : \"403\", \"message\" : \"  " + message + "\", \"description\" : \"\" }";
    }

    private String compose404BulkDeleteMessage(String message, List<String> deletedIds, List<String> notFoundIds) {
        return "{ \"status\" : \"error\", \"code\" : \"404\", \"message\" : \"  " + message + " \"\"deletedIds\" : " + new Gson().toJson(deletedIds) + ",\"notFoundIds\" : " + new Gson().toJson(notFoundIds) + " }";
    }

    private String compose404Message(String message) {
        return "{ \"status\" : \"error\", \"code\" : \"404\", \"message\" : \"  " + message + " \" }";
    }

    private String compose400BulkInsertMessage(String message, List<String> insertedIds, JsonArray errorInClaims) {
        return "{ \"status\" : \"error\", \"code\" : \"400\", \"message\" : \"  " + message + " \", \"insertedIds\" : " + new Gson().toJson(insertedIds) + ",\"errorInClaims\" : " + new Gson().toJson((JsonElement)errorInClaims) + " }";
    }

    private String compose500Message(String message, Throwable throwable) {
        return "{ \"status\" : \"fail\", \"code\" : \"500\", \"message\" : \"  " + message + "\", \"description\" : \"" + throwable.getMessage() + "\" }";
    }

    private String compose500BulkInsertMessage(String message, List<String> insertedIds, JsonArray errorInClaims) {
        return "{ \"status\" : \"fail\", \"code\" : \"500\", \"message\" : \"  " + message + "\", \"description\" : \"\" , \"insertedIds\" : " + new Gson().toJson(insertedIds) + ",\"errorInClaims\" : " + new Gson().toJson((JsonElement)errorInClaims) + " }";
    }

    private String compose204BulkDeleteMessage(List<String> deletedIds, List<String> notFoundIds) {
        return " { \"status\" : \"success\", \"code\": \"204\", \"deletedIds\" : " + new Gson().toJson(deletedIds) + ",\"notFoundIds\" : " + new Gson().toJson(notFoundIds) + "}";
    }

    private String compose201PostMessage(@Context HttpServletRequest request, String claimId) {
        String url = request.getRequestURL().toString();
        return " { \"status\" : \"success\", \"code\": \"201\", \"link\": \"" + url + "/" + claimId + "\" }";
    }

    private String compose201BulkInsertMessage(List<String> insertedIds, JsonArray errorInClaims) {
        return " { \"status\" : \"success\", \"code\": \"201\",\"insertedIds\" : " + new Gson().toJson(insertedIds) + ",\"errorInClaims\" : " + new Gson().toJson((JsonElement)errorInClaims) + "}";
    }

    private String composeDataResponse(HttpServletRequest request, List<Claim> claims, int total, int offset, int limit) {
        if (offset != -1 && limit != -1) {
            return " { \"status\" : \"success\", \"code\": \"200\",  " + this.composeTotalResults(total) + ", " + HelloWorldService.composePaging(request, total, offset, limit) + ", \"data\" : " + new Gson().toJson(claims) + " }";
        }
        return " { \"status\" : \"success\", \"code\": \"200\",  " + this.composeTotalResults(total) + ", \"data\" : " + new Gson().toJson(claims) + " }";
    }

    private String composeDataResponse(String xml) {
        return " { \"status\" : \"success\", \"code\": \"200\", \"data\" : " + XML.toJSONObject((String)xml).toString() + " }";
    }

    private String composeDataResponse(Claim claim) {
        return " { \"status\" : \"success\", \"code\": \"200\", \"data\" : " + new Gson().toJson((Object)claim) + " }";
    }

    private static String composePaging(HttpServletRequest request, int total, int currentOffset, int limit) {
        logger.info((Object)("total " + total));
        logger.info((Object)("currentOffset " + currentOffset));
        logger.info((Object)("limit " + limit));
        String url = request.getRequestURL().toString();
        String first = url + "?offset=0&limit=20";
        int lastPage = total <= limit ? 0 : (total % limit == 0 ? total / limit - 1 : total / limit);
        String last = url + "?offset=" + lastPage + "&limit=20";
        int previousPage = currentOffset - 1 <= 0 ? 0 : currentOffset - 1;
        String previous = url + "?offset=" + previousPage + "&limit=20";
        int nextPage = currentOffset + 1 >= lastPage ? lastPage : currentOffset + 1;
        String next = url + "?offset=" + nextPage + "&limit=20";
        return "\"paging\": [{\"rel\":\"first\", \"href\":\"" + first + "\"}, {\"rel\":\"last\", \"href\":\"" + last + "\"}, {\"rel\":\"previous\", \"href\": \"" + previous + "\"}, {\"rel\":\"next\", \"href\":\"" + next + "\"}]";
    }

    private String composeTotalResults(int total) {
        return "\"total\": \"" + total + "\"";
    }

    public static void main(String[] args) {
    }
}

