package eu.dnetlib.openaire.rest;

import eu.dnetlib.openaire.rest.inputHandler.UserHandler;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Created by sofia on 20/4/2017.
 */
public class Authorization {

    private static Logger logger = Logger.getLogger(Authorization.class);
    List<String> registeredRoles = new ArrayList<String>(Arrays.asList("Super Administrator", "Portal Administrator", "Expert - Community",
            "Expert - Funder", "Curator - Claim", "Curator - Project", "Curator - Community", "Curator - Institution", "Cuthor", "Registered", "User Manager"));
    List<String> adminRoles = new ArrayList<String>(Arrays.asList("Super Administrator", "Curator - Claim", "Portal Administrator"));
    List<String> projectCuratorRoles = new ArrayList<String>(Arrays.asList("Curator - Project"));
    UserHandler userHandler = null;
    String originServer = null;

    //    public static boolean isRegistered(String token) {
//
//        Claims claims = Jwts.parser()
//                .setSigningKey(DatatypeConverter.parseBase64Binary("my-very-secret"))
//                .parseClaimsJws(token).getBody();
//
//        if (claims.get("role").equals("1") || claims.get("role").equals("2")) {
//            logger.debug("It's  registered with role " + claims.get("role"));
//            return true;
//        } else {
//            logger.debug("It's *not*  registered with role " + claims.get("role"));
//
//            return false;
//        }
//    }
//
//    public static boolean isAdmin(String token) {
//        Claims claims = Jwts.parser()
//                .setSigningKey(DatatypeConverter.parseBase64Binary("my-very-secret"))
//                .parseClaimsJws(token).getBody();
//        if (claims.get("role").equals("2")) {
//            logger.debug("It's  admin with role " + claims.get("role"));
//            return true;
//        } else {
//            logger.debug("It's *not*  admin with role " + claims.get("role"));
//            return false;
//        }
//    }
    public boolean isRegistered(String token) {
        UserInfo userInfo = userHandler.getUserInfo(token);
        return isRegistered(userInfo);

    }

    public boolean isRegistered(UserInfo userInfo) {
        if (userInfo != null && userInfo.getEdu_person_entitlements() != null) {

            return hasRole(userInfo.getEdu_person_entitlements(), registeredRoles);
        } else {
            return false;
        }

    }

    public boolean isAdmin(String token) {
        UserInfo userInfo = userHandler.getUserInfo(token);
        return isAdmin(userInfo);

    }

    public boolean isAdmin(UserInfo userInfo) {
        if (userInfo != null && userInfo.getEdu_person_entitlements() != null) {

            return hasRole(userInfo.getEdu_person_entitlements(), adminRoles);
        } else {
            logger.debug(" User has no Valid UserInfo");
            return false;
        }

    }

    public boolean isProjectCurator(String token) {
        UserInfo userInfo = userHandler.getUserInfo(token);
        return isProjectCurator(userInfo);

    }

    public boolean isProjectCurator(UserInfo userInfo) {
        if (userInfo != null && userInfo.getEdu_person_entitlements() != null) {

            return hasRole(userInfo.getEdu_person_entitlements(), projectCuratorRoles);
        } else {
            return false;
        }

    }

    public boolean hasRole(List<String> givenRoles, List<String> authorizedRoles) {

        logger.debug("It's  registered with role " + givenRoles);
        for (String gRole : givenRoles) {
            if (authorizedRoles.indexOf(gRole) != -1) {
                return true;
            }
        }
        logger.debug("Not Authorized. Authorized roles are" + authorizedRoles);
        return false;

    }

    public boolean hasValidOrigin(String origin) {
        if (origin != null && originServer.equals(origin)) {
            return true;
        }
        return false;
    }

    public List<String> getRegisteredRoles() {
        return registeredRoles;
    }

    public void setRegisteredRoles(List<String> registeredRoles) {
        this.registeredRoles = registeredRoles;
    }

    public List<String> getAdminRoles() {
        return adminRoles;
    }

    public void setAdminRoles(List<String> adminRoles) {
        this.adminRoles = adminRoles;
    }

    public List<String> getProjectCuratorRoles() {
        return projectCuratorRoles;
    }

    public void setProjectCuratorRoles(List<String> projectCuratorRoles) {
        this.projectCuratorRoles = projectCuratorRoles;
    }

    public UserHandler getUserHandler() {
        return userHandler;
    }

    public void setUserHandler(UserHandler userHandler) {
        this.userHandler = userHandler;
    }

    public String getOriginServer() {
        return originServer;
    }

    public void setOriginServer(String originServer) {
        this.originServer = originServer;
    }
}
