package eu.dnetlib.openaire.rest.inputHandler;

import com.google.gson.Gson;
import eu.dnetlib.openaire.rest.Authorization;
import eu.dnetlib.openaire.rest.UserInfo;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import javax.xml.bind.DatatypeConverter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * Created by sofia on 20/4/2017.
 */
public class UserHandler{
    private static Logger logger = Logger.getLogger(UserHandler.class);

    String userInfoUrl = null;
//        public  String getMail(String token) {
//
//            Claims claims = Jwts.parser()
//                    .setSigningKey(DatatypeConverter.parseBase64Binary("my-very-secret"))
//                    .parseClaimsJws(token).getBody();
//
//            return (String) claims.get("email");
//
//        }

    public  UserInfo getUserInfo(String accessToken){
        String url=userInfoUrl+accessToken;
        URL obj = null;
        String responseStr=null;
        logger.debug("User info url is "+url);

            try {
                obj = new URL(url);
                HttpURLConnection con = (HttpURLConnection) obj.openConnection();
                logger.debug("User info response code is: " + con.getResponseCode());
                if (con.getResponseCode() != 200) {
                    return null;
                }
                BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                StringBuffer response = new StringBuffer();
                String inputLine;
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine).append("\n");
                }
                in.close();
                responseStr = response.toString();
            }catch(Exception e){
                logger.error("An error occured while trying to fetch user info ",e);
                return null;
            }
        return json2UserInfo(responseStr);
    }

    private  UserInfo json2UserInfo(String json) {

        logger.debug("Try to create userInfo class from json: "+json);
         if (json == null){
            return null;
        }

        BufferedReader br = new BufferedReader(new StringReader(json));
        //convert the json string back to object
        Gson gson = new Gson();
        UserInfo userInfo = null;
        try {
            userInfo = gson.fromJson(br, UserInfo.class);
        }catch(Exception e){
            logger.debug("Error in parsing json response. Given json is : "+json, e);
            return null;
        }

        logger.debug("Original response.........: "+userInfo.toString());
        try {
        if(userInfo != null && userInfo.getEdu_person_entitlements() != null ) {

            for (int i = 0; i < userInfo.getEdu_person_entitlements().size(); i++) {
                String role = userInfo.getEdu_person_entitlements().get(i);
                logger.debug("AAI role: "+role);
                role = role.split(":")[role.split(":").length-1];
                role = role.split("#")[0];
                role = role.replace("+"," ");
                logger.debug("Adding parsed role : "+role);
                userInfo.getEdu_person_entitlements().set(i,role);
            }
        }
        }catch(Exception e){
            logger.debug("Error in parsing  Edu_person_entitlements : ",e);
            return null;
        }
        logger.debug("After handling roles : "+userInfo.toString());


        return userInfo;
    }

    public String getUserInfoUrl() {
        return userInfoUrl;
    }

    public void setUserInfoUrl(String userInfoUrl) {
        this.userInfoUrl = userInfoUrl;
    }

    public static void main(String[] args) throws IOException {
//        BasicConfigurator.configure();
//        ApplicationContext context = new ClassPathXmlApplicationContext("eu/dnetlib/openaire/rest/springContext-claims-authorization.xml");
//
//        Authorization authorization =  context.getBean(Authorization.class);
//        UserHandler userHandler = context.getBean(UserHandler.class);
//        System.out.println("\n\nAdmin Roles "+authorization.getAdminRoles().size()+"   "+authorization.getAdminRoles()+"\n\n\n");
//        System.out.println("\n\ngetProjectCuratorRoles Roles "+authorization.getProjectCuratorRoles().size()+"   "+authorization.getProjectCuratorRoles()+"\n\n\n");
//        System.out.println("\n\ngetRegisteredRoles Roles "+authorization.getRegisteredRoles().size()+"   "+authorization.getRegisteredRoles()+"\n\n\n");
//        System.out.println("\n\nIs Admin::\n"+authorization.isRegistered("eyJraWQiOiJvaWRjIiwiYWxnIjoiUlMyNTYifQ.eyJzdWIiOiIwOTMxNzMwMTMyODMzNjMyQG9wZW5taW50ZWQuZXUiLCJhenAiOiIyNGU4MzE3Ni0xMzEyLTRiYTMtYmMwYi1mZmVlYmVhMTYwM2UiLCJpc3MiOiJodHRwczpcL1wvYWFpLm9wZW5taW50ZWQuZXVcL29pZGNcLyIsImV4cCI6MTQ5OTg4MjI4NCwiaWF0IjoxNDk5ODY3ODg0LCJqdGkiOiIxNzJiOWNkYS1kNmZjLTQ3MTgtYTI1My02YTJjYmNiYmI0ZWIifQ.XtKm96oOeRe0_7mzr_NPdFAG6JJN3dh9Oy6-bFHE59UaN3TMuZAYgLND49vryWK_m4s23F_1TvZAN7WMDnkx3YH6RqTUsMS57sJGIOoDg4eYSzgDfLriyaANqp1Fh2PotMXWuFZXmtKdyLYw2jfcnBXjfd7DkMHylsFWII88GQVRFujsrJfjr5DKcz09Ad_tF874r-Emq0ARxtSHjmjp56cKmiia9GcjOgMVRMdUgArVKPToiMoYizXyG51t3yOnYI6JI0batB3UjmocX-YXBJmLZfS3zqlaKuf_hHgcs09EQK_McJ_igpgZ9CeBUHyDzzITtniLmftKB7o_AfxaMw")
//                +"\n\n\n");
//        userHandler.json2UserInfo("{\"sub\":\"123456@openminted.eu\",\"name\":\"όνομα και επιθετο\",\"given_name\":\"όνομα\",\"family_name\":\"επίθετο\",\"email\":\"mail1@mail.com\",\"edu_person_entitlements\":[\"urn:mace:openminted.eu:aai.openminted.eu:group:OpenAIRE+Super+Administrator\",\"urn:mace:openminted.eu:aai.openminted.eu:group:OpenAIRE+User+Manager\"]}");
//        UserInfo u = userHandler.json2UserInfo("{\"sub\":\"12345678@openminted.eu\",\"name\":\" a name\",\"given_name\":\"a\",\"family_name\":\"name\",\"email\":\"mail2@mail.com\",\"edu_person_scoped_affiliations\":[\"faculty@university\"],\"edu_person_entitlements\":[\"urn:mace:openminted.eu:aai.openminted.eu:group:OpenAIRE+Super+Administrator\"]}");
//        boolean b=authorization.isProjectCurator(u);
//        System.out.println(b);
//        userHandler.json2UserInfo("{\"sub\":\"1234567899@openminted.eu\",\"name\":\" test name\",\"given_name\":\"test\",\"family_name\":\"test surname\",\"email\":\"mail2@mail.com\",\"edu_person_scoped_affiliations\":[\"faculty@uni\"]}");
//        userHandler.json2UserInfo(null);
//        userHandler.json2UserInfo("mpla mpla mpla .... {}");
//        userHandler.getUserInfo("eyJraWQiOiJvaWRjIiwiYWxnIjoiUlMyNTYifQ.eyJzdWIiOiIwOTMxNzMwMTMyODMzNjMyQG9wZW5taW50ZWQuZXUiLCJhenAiOiIyNGU4MzE3Ni0xMzEyLTRiYTMtYmMwYi1mZmVlYmVhMTYwM2UiLCJpc3MiOiJodHRwczpcL1wvYWFpLm9wZW5taW50ZWQuZXVcL29pZGNcLyIsImV4cCI6MTQ5ODQ4NTk3NiwiaWF0IjoxNDk4NDcxNTc2LCJqdGkiOiJkMWRlZjc1Yi00MTEyLTRiZDktYTIyNi0wZThhOWI2M2Y3MWQifQ.WVYOb_yO8OaxIIt2jRYEDQBhGGFRDTBw3DgtVV_smuN5yx1ScCj6aehLu3JKPSArme4m2SGF4TEGhpwNJkwhM2WapGtxmtuCmCzYIo_QlC1Yki9hr2OT2rXMcQsJCiKaBSf6pLue6Sn78GMB5yaUTvOQHRgidXGiZXH5lsuZUx15Q6Equ_wzond_rgP9mRheRkTyIFuvvg4PuzmudBc11Ty863vIIQtoWF7_p98zTbHxiNF9lLPwzPZKxDoQ8JeayQEC-jsWVLgxmp-h0jG_Ko5jFVVJeeosqMMucOrs2FT_NKHVYVqB6VVh0C6nOufeiLrNDeMUlDT4dAvKD2zE9w");
    }
}
