/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.rest.inputHandler;

import com.google.gson.Gson;
import eu.dnetlib.openaire.rest.UserInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.log4j.Logger;

public class UserHandler {
    private static Logger logger = Logger.getLogger(UserHandler.class);
    String userInfoUrl = null;

    public UserInfo getUserInfo(String accessToken) {
        String url = this.userInfoUrl + accessToken;
        URL obj = null;
        String responseStr = null;
        logger.debug((Object)("User info url is " + url));
        try {
            String inputLine;
            obj = new URL(url);
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            logger.debug((Object)("User info response code is: " + con.getResponseCode()));
            if (con.getResponseCode() != 200) {
                return null;
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine).append("\n");
            }
            in.close();
            responseStr = response.toString();
        }
        catch (Exception e) {
            logger.error((Object)"An error occured while trying to fetch user info ", (Throwable)e);
            return null;
        }
        return this.json2UserInfo(responseStr);
    }

    private UserInfo json2UserInfo(String json) {
        logger.debug((Object)("Try to create userInfo class from json: " + json));
        if (json == null) {
            return null;
        }
        BufferedReader br = new BufferedReader(new StringReader(json));
        Gson gson = new Gson();
        UserInfo userInfo = null;
        try {
            userInfo = (UserInfo)gson.fromJson((Reader)br, UserInfo.class);
        }
        catch (Exception e) {
            logger.debug((Object)("Error in parsing json response. Given json is : " + json), (Throwable)e);
            return null;
        }
        logger.debug((Object)("Original response.........: " + userInfo.toString()));
        try {
            if (userInfo != null && userInfo.getEdu_person_entitlements() != null) {
                for (int i = 0; i < userInfo.getEdu_person_entitlements().size(); ++i) {
                    String role = userInfo.getEdu_person_entitlements().get(i);
                    logger.debug((Object)("AAI role: " + role));
                    role = role.split(":")[role.split(":").length - 1];
                    role = role.split("#")[0];
                    role = role.replace("+", " ");
                    logger.debug((Object)("Adding parsed role : " + role));
                    userInfo.getEdu_person_entitlements().set(i, role);
                }
            }
        }
        catch (Exception e) {
            logger.debug((Object)"Error in parsing  Edu_person_entitlements : ", (Throwable)e);
            return null;
        }
        logger.debug((Object)("After handling roles : " + userInfo.toString()));
        return userInfo;
    }

    public String getUserInfoUrl() {
        return this.userInfoUrl;
    }

    public void setUserInfoUrl(String userInfoUrl) {
        this.userInfoUrl = userInfoUrl;
    }

    public static void main(String[] args) throws IOException {
    }
}

