/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.rest;

import com.google.gson.JsonObject;
import eu.dnetlib.data.claims.entity.Metrics;
import eu.dnetlib.data.claims.handler.MetricsHandler;
import eu.dnetlib.data.claims.sql.SQLStoreException;
import java.sql.SQLException;
import java.util.HashMap;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.CrossOrigin;

@Component
@CrossOrigin(origins={"*"})
@Path(value="/report")
public class MetricsService {
    private static final Logger logger = Logger.getLogger(MetricsService.class);
    @Autowired
    private MetricsHandler metricsHandler = null;

    public static void main(String[] args) {
    }

    @GET
    @Path(value="/calc")
    @Produces(value={"text/plain"})
    public String calculateMetrics() throws SQLStoreException, Exception {
        this.metricsHandler.calculateMetrics();
        return "metrics calculated!";
    }

    @GET
    @Path(value="/metrics")
    @Produces(value={"text/plain"})
    public String getMetrics() throws SQLStoreException, SQLException {
        Metrics metrics = this.metricsHandler.getMetrics();
        String response = "";
        if (metrics != null) {
            HashMap worksPerDashboard = new HashMap();
            response = response + "# TYPE claims gauge\n";
            for (JsonObject dashboardMetrics : metrics.getMetrics_per_dashboard()) {
                if (dashboardMetrics.get("claims") == null) continue;
                response = response + "claims{environment=" + dashboardMetrics.get("environment") + " portal=" + dashboardMetrics.get("dashboard") + "} " + dashboardMetrics.get("claims") + "\n";
            }
            response = response + "# TYPE claims_users gauge\n";
            for (JsonObject dashboardMetrics : metrics.getMetrics_per_dashboard()) {
                if (dashboardMetrics.get("users") == null) continue;
                response = response + "claims_users{environment=" + dashboardMetrics.get("environment") + " portal=" + dashboardMetrics.get("dashboard") + "} " + dashboardMetrics.get("users") + "\n";
            }
            response = response + "# TYPE claims_projects gauge\n";
            for (JsonObject dashboardMetrics : metrics.getMetrics_per_dashboard()) {
                if (dashboardMetrics.get("projects") == null) continue;
                response = response + "claims_projects{environment=" + dashboardMetrics.get("environment") + " portal=" + dashboardMetrics.get("dashboard") + "} " + dashboardMetrics.get("projects") + "\n";
            }
            response = response + "# TYPE claims_eu_projects gauge\n";
            for (JsonObject dashboardMetrics : metrics.getMetrics_per_dashboard()) {
                if (dashboardMetrics.get("eu_projects") == null) continue;
                response = response + "claims_eu_projects{environment=" + dashboardMetrics.get("environment") + " portal=" + dashboardMetrics.get("dashboard") + "} " + dashboardMetrics.get("eu_projects") + "\n";
            }
            response = response + "# TYPE claims_countries gauge\n";
            for (JsonObject dashboardMetrics : metrics.getMetrics_per_dashboard()) {
                if (dashboardMetrics.get("countries") == null) continue;
                response = response + "claims_countries{environment=" + dashboardMetrics.get("environment") + " portal=" + dashboardMetrics.get("dashboard") + "} " + dashboardMetrics.get("countries") + "\n";
            }
            response = response + "# TYPE claims_unique_research_results gauge\n";
            for (JsonObject dashboardMetrics : metrics.getMetrics_per_dashboard()) {
                if (dashboardMetrics.get("research_results") == null) continue;
                response = response + "claims_unique_research_results{environment=" + dashboardMetrics.get("environment") + " portal=" + dashboardMetrics.get("dashboard") + "} " + dashboardMetrics.get("research_results") + "\n";
            }
            if (metrics.getDate() != null) {
                response = response + "claims_last_metrics_updater_run_timestamp_seconds " + metrics.getDate().getTime() / 1000L + "\n";
            }
        }
        return response;
    }

    private String composeResults(int total, String label) {
        return "\"" + label + "\": \"" + total + "\"";
    }

    private String composeTotalResults(int total) {
        return "\"total\": \"" + total + "\"";
    }

    private String composeDataResponse(int count) {
        return " { \"status\" : \"success\", \"code\": \"200\",  " + this.composeTotalResults(count) + " }";
    }

    private String compose500Message(String message, Throwable throwable) {
        return "{ \"status\" : \"fail\", \"code\" : \"500\", \"message\" : \"  " + message + "\", \"description\" : \"" + throwable.getMessage() + "\" }";
    }
}

