/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.rest;

import eu.dnetlib.openaire.rest.UserInfo;
import eu.dnetlib.openaire.rest.inputHandler.UserHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class Authorization {
    private static Logger logger = Logger.getLogger(Authorization.class);
    List<String> registeredRoles = new ArrayList<String>(Arrays.asList("Super Administrator", "Portal Administrator", "Expert - Community", "Expert - Funder", "Curator - Claim", "Curator - Project", "Curator - Community", "Curator - Institution", "Cuthor", "Registered", "User Manager"));
    List<String> claimCuratorRoles = new ArrayList<String>(Arrays.asList("Super Administrator", "Curator - Claim", "Portal Administrator"));
    List<String> projectCuratorRoles = new ArrayList<String>(Arrays.asList("Curator - Project"));
    List<String> communityCuratorRoles = new ArrayList<String>(Arrays.asList("Curator - Community"));
    List<String> portalAdminRoles = new ArrayList<String>(Arrays.asList("Portal Administrator"));
    UserHandler userHandler = null;
    String originServer = null;

    public boolean isRegistered(String token) {
        UserInfo userInfo = this.userHandler.getUserInfo(token);
        return this.isRegistered(userInfo);
    }

    public void logStatus(String token, String cookie) {
        if (token == null || token.isEmpty()) {
            logger.debug((Object)("No proper value: header \"X-XSRF-TOKEN\" has value " + token));
        } else if (cookie == null || cookie.isEmpty() || !cookie.equals(token)) {
            logger.debug((Object)("No proper value: cookie  \"AccessToken\" has value  " + cookie));
        } else if (!cookie.equals(token)) {
            logger.debug((Object)("No proper values:for cookie " + cookie + " and token " + token));
        }
    }

    public boolean isRegistered(UserInfo userInfo) {
        if (userInfo != null && userInfo.getEdu_person_entitlements() != null) {
            return this.hasRole(userInfo.getEdu_person_entitlements(), this.registeredRoles);
        }
        return false;
    }

    public boolean isClaimCurator(String token) {
        UserInfo userInfo = this.userHandler.getUserInfo(token);
        return this.isClaimCurator(userInfo);
    }

    public boolean isClaimCurator(UserInfo userInfo) {
        if (userInfo != null && userInfo.getEdu_person_entitlements() != null) {
            return this.hasRole(userInfo.getEdu_person_entitlements(), this.claimCuratorRoles);
        }
        logger.debug((Object)" User has no Valid UserInfo");
        return false;
    }

    public boolean isCommunityCurator(String token) {
        UserInfo userInfo = this.userHandler.getUserInfo(token);
        return this.isCommunityCurator(userInfo);
    }

    public boolean isCommunityCurator(UserInfo userInfo) {
        if (userInfo != null && userInfo.getEdu_person_entitlements() != null) {
            return this.hasRole(userInfo.getEdu_person_entitlements(), this.communityCuratorRoles);
        }
        logger.debug((Object)" User has no Valid UserInfo");
        return false;
    }

    public boolean isProjectCurator(String token) {
        UserInfo userInfo = this.userHandler.getUserInfo(token);
        return this.isProjectCurator(userInfo);
    }

    public boolean isProjectCurator(UserInfo userInfo) {
        if (userInfo != null && userInfo.getEdu_person_entitlements() != null) {
            return this.hasRole(userInfo.getEdu_person_entitlements(), this.projectCuratorRoles);
        }
        return false;
    }

    public boolean isPortalAdministrator(String token) {
        UserInfo userInfo = this.userHandler.getUserInfo(token);
        return this.isPortalAdministrator(userInfo);
    }

    public boolean isPortalAdministrator(UserInfo userInfo) {
        if (userInfo != null && userInfo.getEdu_person_entitlements() != null) {
            return this.hasRole(userInfo.getEdu_person_entitlements(), this.portalAdminRoles);
        }
        logger.debug((Object)" User has no Valid UserInfo");
        return false;
    }

    public boolean hasRole(List<String> givenRoles, List<String> authorizedRoles) {
        logger.debug((Object)("It's  registered with role " + givenRoles));
        for (String gRole : givenRoles) {
            if (authorizedRoles.indexOf(gRole) == -1) continue;
            return true;
        }
        logger.debug((Object)("Not Authorized. Authorized roles are" + authorizedRoles));
        return false;
    }

    public boolean hasValidOrigin(String origin) {
        logger.debug((Object)("Origin is " + origin + " originServer: " + this.originServer));
        if (origin != null && origin.indexOf(this.originServer) != -1) {
            return true;
        }
        logger.debug((Object)("Not valid origin. Origin server is \"" + origin + "\", but expected value is \"" + this.originServer + "\". If the expec cted value is not right, check properties file. "));
        return false;
    }

    public boolean hasBasicAuthorization(String token, String origin, String cookie) {
        return token != null && !token.isEmpty() && cookie != null && !cookie.isEmpty() && cookie.equals(token) && this.hasValidOrigin(origin);
    }

    public List<String> getRegisteredRoles() {
        return this.registeredRoles;
    }

    public void setRegisteredRoles(List<String> registeredRoles) {
        this.registeredRoles = registeredRoles;
    }

    public List<String> getClaimCuratorRoles() {
        return this.claimCuratorRoles;
    }

    public void setClaimCuratorRoles(List<String> claimCuratorRoles) {
        this.claimCuratorRoles = claimCuratorRoles;
    }

    public List<String> getCommunityCuratorRoles() {
        return this.communityCuratorRoles;
    }

    public void setCommunityCuratorRoles(List<String> communityCuratorRoles) {
        this.communityCuratorRoles = communityCuratorRoles;
    }

    public List<String> getProjectCuratorRoles() {
        return this.projectCuratorRoles;
    }

    public void setProjectCuratorRoles(List<String> projectCuratorRoles) {
        this.projectCuratorRoles = projectCuratorRoles;
    }

    public UserHandler getUserHandler() {
        return this.userHandler;
    }

    public void setUserHandler(UserHandler userHandler) {
        this.userHandler = userHandler;
    }

    public String getOriginServer() {
        return this.originServer;
    }

    public void setOriginServer(String originServer) {
        this.originServer = originServer;
    }
}

