package eu.dnetlib.openaire.rest.security;

import io.jsonwebtoken.*;
import org.apache.log4j.Logger;

import javax.xml.bind.DatatypeConverter;

/**
 * Created by kiatrop on 10/4/2017.
 */
public class JWTValidator {

    private static final Logger logger = Logger.getLogger(JWTValidator.class);

    public static boolean isValid(String token) {

        //String subject = "my-very-secret";
        try {

            //This line will throw an exception if it is not a signed JWS (as expected)
            Claims claims = Jwts.parser()
                .setSigningKey(DatatypeConverter.parseBase64Binary("my-very-secret"))
                .parseClaimsJws(token).getBody();

            logger.debug("Id: " + claims.get("userId"));
            logger.debug("Subject: " + claims.getSubject());
            logger.debug("Fullname: " + claims.get("fullname"));
            logger.debug("Email: " + claims.get("email"));
            logger.debug("Role: " + claims.get("role"));
            logger.debug("Expiration: " + claims.getExpiration());

            return true;

        } catch (SignatureException e) {
            logger.error("Either calculating a signature or verifying an existing signature of a JWT failed", e);
            return false;
        } catch(PrematureJwtException e) {
            logger.error("A JWT was accepted before it is allowed to be accessed and must be rejected", e);
            return false;
        } catch(ClaimJwtException e){
            logger.error("After a validation of a JWT claim failed", e);
            return false;
        } catch(MalformedJwtException e){
            logger.error("A JWT was not correctly constructed and should be rejected", e);
            return false;
        } catch(UnsupportedJwtException e){
            logger.error("Receiving a JWT in a particular format/configuration that does not match the format expected by the application", e);
            return false;
        }
    }

//    public static void main(String[] args) {
//
//        // valid (isValid("eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiJBcmdpcm8iLCJmdWxsbmFtZSI6IkFyZ2lybyBLb2tvZ2lhbmFraSIsInVzZXJJZCI6IjgiLCJlbWFpbCI6ImFyZ2lyb0BnbWFpbC5jb20iLCJyb2xlIjoyLCJleHAiOjE0OTIwMDEyMzN9.u2xTTyjF6_n60yiz-Pfj72TQIaVNRgxt7Qe8w_AxoTBulKuiq6ldzZHDvgcef2jsA12TFRgfIyfXhsTj-04P5A"))
//        // not valid "eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiJBcmdpcm8iLCJmdWxsbmFtZSI6IkFyZ2lybyBLb2tvZ2lhbmFraSIsInVzZXJJZCI6IjgiLCJlbWFpbCI6ImFyZ2lyb0BnbWFpbC5jb20iLCJyb2xlIjoyLCJleHAiOjE0OTE5ODk2Njh9.JUiFGEverBVbo3eXlV2nX265cwNTYH1EJGZT0IcGyY31WUDHiGmtnTY-NwZsy0R93irVhAzVhTlmZI_DSRQ"
//        //if (isValid("eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiJzYmEiLCJmdWxsbmFtZSI6InNvZmlhICIsInVzZXJJZCI6IjYiLCJlbWFpbCI6InNvZmllX21wbEBob3RtYWlsLmNvbSIsInJvbGUiOjEsImV4cCI6MTQ5Mjc3ODY2M30.LcgYcBuI0V8tsZZR_Pnnb5Kk0_GfblxNC6FH1CHT2q7u4j9hcETb1EYLIKPZdkErXJ_MSC1jHNUiS5qCzEQQ2w"))
//
//        if(isValid("eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiJBcmdpcm8iLCJmdWxsbmFtZSI6IkFyZ2lybyBLb2tvZ2lhbmFraSIsInVzZXJJZCI6IjgiLCJlbWFpbCI6ImFyZ2lyb0BnbWFpbC5jb20iLCJyb2xlIjoyLCJleHAiOjE0OTI3ODY4MTl9.F-cFGmSvZLAF70PCz9PE6jOwSg6aAiUW2lklkS-eKCxkjwbqPJLWlNWP10Czg4j1_iKDTvHR7wbhbRyJPoqvNQ"))
//            System.out.println("Valid");
//        else
//            System.out.println("Not Valid");
//
//    }

}
