package eu.dnetlib.openaire.rest;

import eu.dnetlib.openaire.rest.inputHandler.UserHandler;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Created by sofia on 20/4/2017.
 */
public class Authorization {

    private static Logger logger = Logger.getLogger(Authorization.class);
    List<String> registeredRoles = new ArrayList<String>(Arrays.asList("Super Administrator", "Portal Administrator", "Expert - Community",
            "Expert - Funder", "Curator - Claim", "Curator - Project", "Curator - Community", "Curator - Institution", "Cuthor", "Registered", "User Manager"));
    List<String> claimCuratorRoles = new ArrayList<String>(Arrays.asList("Super Administrator", "Curator - Claim", "Portal Administrator"));
    List<String> projectCuratorRoles = new ArrayList<String>(Arrays.asList("Curator - Project"));
    List<String> communityCuratorRoles = new ArrayList<String>(Arrays.asList("Curator - Community"));
    List<String> portalAdminRoles = new ArrayList<String>(Arrays.asList("Portal Administrator"));
    UserHandler userHandler = null;
    String originServer = null;

    //    public static boolean isRegistered(String token) {
//
//        Claims claims = Jwts.parser()
//                .setSigningKey(DatatypeConverter.parseBase64Binary("my-very-secret"))
//                .parseClaimsJws(token).getBody();
//
//        if (claims.get("role").equals("1") || claims.get("role").equals("2")) {
//            logger.debug("It's  registered with role " + claims.get("role"));
//            return true;
//        } else {
//            logger.debug("It's *not*  registered with role " + claims.get("role"));
//
//            return false;
//        }
//    }
//
//    public static boolean isClaimCurator(String token) {
//        Claims claims = Jwts.parser()
//                .setSigningKey(DatatypeConverter.parseBase64Binary("my-very-secret"))
//                .parseClaimsJws(token).getBody();
//        if (claims.get("role").equals("2")) {
//            logger.debug("It's  admin with role " + claims.get("role"));
//            return true;
//        } else {
//            logger.debug("It's *not*  admin with role " + claims.get("role"));
//            return false;
//        }
//    }
    public boolean isRegistered(String token) {
        UserInfo userInfo = userHandler.getUserInfo(token);
        return isRegistered(userInfo);

    }
    public void logStatus(String token, String cookie) {

        if(token == null || token.isEmpty()) {
            logger.debug("No proper value: header \"X-XSRF-TOKEN\" has value " + token);
        }else if(cookie == null || cookie.isEmpty() || !cookie.equals(token)) {
            logger.debug("No proper value: cookie  \"AccessToken\" has value  " + cookie);
        }else if( !cookie.equals(token)) {
            logger.debug("No proper values:for cookie " + cookie + " and token "+token);
        }
    }

    public boolean isRegistered(UserInfo userInfo) {
        if (userInfo != null && userInfo.getEdu_person_entitlements() != null) {

            return hasRole(userInfo.getEdu_person_entitlements(), registeredRoles);
        } else {
            return false;
        }

    }

    public boolean isClaimCurator(String token) {
        UserInfo userInfo = userHandler.getUserInfo(token);
        return isClaimCurator(userInfo);

    }

    public boolean isClaimCurator(UserInfo userInfo) {
        if (userInfo != null && userInfo.getEdu_person_entitlements() != null) {

            return hasRole(userInfo.getEdu_person_entitlements(), claimCuratorRoles);
        } else {
            logger.debug(" User has no Valid UserInfo");
            return false;
        }

    }

    public boolean isCommunityCurator(String token) {
        UserInfo userInfo = userHandler.getUserInfo(token);
        return isCommunityCurator(userInfo);

    }

    public boolean isCommunityCurator(UserInfo userInfo) {
        if (userInfo != null && userInfo.getEdu_person_entitlements() != null) {

            return hasRole(userInfo.getEdu_person_entitlements(), communityCuratorRoles);
        } else {
            logger.debug(" User has no Valid UserInfo");
            return false;
        }

    }
    public boolean isProjectCurator(String token) {
        UserInfo userInfo = userHandler.getUserInfo(token);
        return isProjectCurator(userInfo);

    }

    public boolean isProjectCurator(UserInfo userInfo) {
        if (userInfo != null && userInfo.getEdu_person_entitlements() != null) {

            return hasRole(userInfo.getEdu_person_entitlements(), projectCuratorRoles);
        } else {
            return false;
        }

    }

    public boolean isPortalAdministrator(String token) {
        UserInfo userInfo = userHandler.getUserInfo(token);
        return isPortalAdministrator(userInfo);

    }

    public boolean isPortalAdministrator(UserInfo userInfo) {
        if (userInfo != null && userInfo.getEdu_person_entitlements() != null) {

            return hasRole(userInfo.getEdu_person_entitlements(), portalAdminRoles);
        } else {
            logger.debug(" User has no Valid UserInfo");
            return false;
        }

    }

    public boolean hasRole(List<String> givenRoles, List<String> authorizedRoles) {

        logger.debug("It's  registered with role " + givenRoles);
        for (String gRole : givenRoles) {
            if (authorizedRoles.indexOf(gRole) != -1) {
                return true;
            }
        }
        logger.debug("Not Authorized. Authorized roles are" + authorizedRoles);
        return false;

    }

    public boolean hasValidOrigin(String origin) {
        logger.debug("Origin is "+origin +" originServer: "+originServer);
        if (origin != null && origin.indexOf(originServer)!=-1) {
            return true;
        }
        logger.debug("Not valid origin. Origin server is \"" + origin + "\", but expected value is \"" + originServer + "\". If the expec cted value is not right, check properties file. ");
        return false;
    }

    public boolean hasBasicAuthorization(String token, String origin, String  cookie){
        if(token == null || token.isEmpty() || cookie == null || cookie.isEmpty() || !cookie.equals(token)|| !hasValidOrigin(origin)){
            return false;
        }
        return true;
    }

    public List<String> getRegisteredRoles() {
        return registeredRoles;
    }

    public void setRegisteredRoles(List<String> registeredRoles) {
        this.registeredRoles = registeredRoles;
    }

    public List<String> getClaimCuratorRoles() {
        return claimCuratorRoles;
    }

    public void setClaimCuratorRoles(List<String> claimCuratorRoles) {
        this.claimCuratorRoles = claimCuratorRoles;
    }

    public List<String> getCommunityCuratorRoles() {
        return communityCuratorRoles;
    }

    public void setCommunityCuratorRoles(List<String> communityCuratorRoles) {
        this.communityCuratorRoles = communityCuratorRoles;
    }

    public List<String> getProjectCuratorRoles() {
        return projectCuratorRoles;
    }

    public void setProjectCuratorRoles(List<String> projectCuratorRoles) {
        this.projectCuratorRoles = projectCuratorRoles;
    }

    public UserHandler getUserHandler() {
        return userHandler;
    }

    public void setUserHandler(UserHandler userHandler) {
        this.userHandler = userHandler;
    }

    public String getOriginServer() {
        return originServer;
    }

    public void setOriginServer(String originServer) {
        this.originServer = originServer;
    }
}
