/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.rest;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.dnetlib.data.claims.entity.Claim;
import eu.dnetlib.data.claims.entity.Notification;
import eu.dnetlib.data.claims.handler.ClaimHandler;
import eu.dnetlib.data.claims.handler.DirectIndexHandler;
import eu.dnetlib.data.claims.handler.FetchClaimHandler;
import eu.dnetlib.data.claims.handler.FetchNotificationHandler;
import eu.dnetlib.data.claims.handler.FetchProjectHandler;
import eu.dnetlib.data.claims.handler.NotificationHandler;
import eu.dnetlib.data.claims.sql.SQLStoreException;
import eu.dnetlib.data.claims.utils.ClaimValidationException;
import eu.dnetlib.data.emailSender.EmailSender;
import eu.dnetlib.openaire.rest.Authorization;
import eu.dnetlib.openaire.rest.UserInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.validator.EmailValidator;
import org.apache.log4j.Logger;
import org.json.XML;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.CrossOrigin;

@Component
@CrossOrigin(origins={"*"})
@Path(value="/claimsService")
public class ClaimsService {
    private static final Logger logger = Logger.getLogger(ClaimsService.class);
    @Autowired
    private FetchClaimHandler fetchClaimHandler = null;
    @Autowired
    private FetchProjectHandler fetchProjectHandler = null;
    @Autowired
    private FetchNotificationHandler fetchNotificationHandler = null;
    @Autowired
    private NotificationHandler notificationHandler = null;
    @Autowired
    private ClaimHandler claimHandler = null;
    @Autowired
    private DirectIndexHandler directIndexHandler = null;
    @Autowired
    public Authorization authorization = null;
    @Autowired
    private String defaultFrequencyInHours;
    @Autowired
    private EmailSender emailSender;

    @GET
    @Path(value="projects/{projectId}/claims")
    @Produces(value={"application/json"})
    public Response getProjectClaims(@PathParam(value="projectId") String projectId, @DefaultValue(value="0") @QueryParam(value="offset") int offset, @DefaultValue(value="20") @QueryParam(value="limit") int limit, @DefaultValue(value="") @QueryParam(value="keyword") String keyword, @DefaultValue(value="") @QueryParam(value="sortby") String orderby, @DefaultValue(value="true") @QueryParam(value="descending") boolean descending, @DefaultValue(value="") @QueryParam(value="types") List<String> types, @HeaderParam(value="X-XSRF-TOKEN") String token, @CookieParam(value="AccessToken") String cookie, @Context HttpServletRequest request) {
        if (token == null || token.isEmpty() || cookie == null || cookie.isEmpty() || !cookie.equals(token)) {
            this.authorization.logStatus(token, cookie);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. Maybe you are not registered.")).type("application/json").build();
        }
        if (this.authorization.isClaimCurator(token)) {
            int total = -1;
            if (projectId == null || projectId.isEmpty()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.compose400Message("Project id cannot be empty.")).type("application/json").build();
            }
            List claims = null;
            try {
                claims = this.fetchClaimHandler.fetchClaimsByProject(projectId, Integer.valueOf(limit), Integer.valueOf(offset), keyword, orderby, descending, types, false);
                total = this.fetchClaimHandler.countClaimsByProject(projectId, keyword, types);
            }
            catch (SQLStoreException | Exception e) {
                logger.error((Object)("Could not fetch claims for project with id " + projectId), e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.compose500Message("Fail to fetch claims for projects with id " + projectId + ".", e)).type("application/json").build();
            }
            return Response.status((int)200).entity((Object)this.composeDataResponse(request, claims, total, offset, limit)).build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access")).type("application/json").build();
    }

    @GET
    @Path(value="projects/{projectId}/all_claims")
    @Produces(value={"application/json"})
    public Response getAllProjectClaims(@PathParam(value="projectId") String projectId, @DefaultValue(value="-1") @QueryParam(value="offset") int offset, @DefaultValue(value="-1") @QueryParam(value="limit") int limit, @DefaultValue(value="") @QueryParam(value="keyword") String keyword, @DefaultValue(value="") @QueryParam(value="sortby") String orderby, @DefaultValue(value="true") @QueryParam(value="descending") boolean descending, @DefaultValue(value="") @QueryParam(value="types") List<String> types, @HeaderParam(value="X-XSRF-TOKEN") String token, @CookieParam(value="AccessToken") String cookie, @Context HttpServletRequest request) {
        if (token == null || token.isEmpty() || cookie == null || cookie.isEmpty() || !cookie.equals(token)) {
            this.authorization.logStatus(token, cookie);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. Maybe you are not registered.")).type("application/json").build();
        }
        UserInfo userInfo = this.authorization.getUserHandler().getUserInfo(token);
        String userMail = userInfo.getEmail();
        int total = -1;
        if (projectId == null || projectId.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.compose400Message("Project id cannot be empty.")).type("application/json").build();
        }
        List claims = null;
        try {
            boolean forbidden = true;
            if (this.authorization.isProjectCurator(userInfo)) {
                forbidden = false;
            } else {
                List contact_emails = this.fetchProjectHandler.fetchContactEmailsByProjectId(projectId);
                logger.debug((Object)contact_emails);
                if (contact_emails != null && contact_emails.contains(userMail)) {
                    forbidden = false;
                }
            }
            if (forbidden) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access")).type("application/json").build();
            }
            claims = offset == -1 && limit == -1 ? this.fetchClaimHandler.fetchClaimsByProject(projectId, null, null, keyword, orderby, descending, types, true) : this.fetchClaimHandler.fetchClaimsByProject(projectId, Integer.valueOf(limit), Integer.valueOf(offset), keyword, orderby, descending, types, true);
            total = this.fetchClaimHandler.countClaimsByProject(projectId, keyword, types);
            return Response.status((int)200).entity((Object)this.composeDataResponse(request, claims, total, offset, limit)).build();
        }
        catch (SQLStoreException | Exception e) {
            logger.error((Object)("Could not fetch claims for project with id " + projectId), e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.compose500Message("Fail to fetch claims for projects with id " + projectId + ".", e)).type("application/json").build();
        }
    }

    @GET
    @Path(value="/contexts/{contextId}/claims")
    @Produces(value={"application/json"})
    public Response getContextClaims(@PathParam(value="contextId") String contextId, @DefaultValue(value="0") @QueryParam(value="offset") int offset, @DefaultValue(value="20") @QueryParam(value="limit") int limit, @DefaultValue(value="") @QueryParam(value="keyword") String keyword, @DefaultValue(value="") @QueryParam(value="sortby") String orderby, @DefaultValue(value="true") @QueryParam(value="descending") boolean descending, @DefaultValue(value="") @QueryParam(value="types") List<String> types, @HeaderParam(value="X-XSRF-TOKEN") String token, @CookieParam(value="AccessToken") String cookie, @Context HttpServletRequest request) {
        if (token == null || token.isEmpty() || cookie == null || cookie.isEmpty() || !cookie.equals(token)) {
            this.authorization.logStatus(token, cookie);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. Maybe you are not registered.")).type("application/json").build();
        }
        UserInfo userInfo = this.authorization.getUserHandler().getUserInfo(token);
        if (this.authorization.isCommunityCurator(userInfo) || this.authorization.isClaimCurator(token) || this.emailSender.getManagerUtils().isCommunityManager(contextId, userInfo.email).booleanValue()) {
            int total = -1;
            if (contextId == null || contextId.isEmpty()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.compose400Message("Context id cannot be empty.")).type("application/json").build();
            }
            logger.debug((Object)("Types are " + types));
            List claims = null;
            try {
                claims = this.fetchClaimHandler.fetchClaimsByContext(contextId, Integer.valueOf(limit), Integer.valueOf(offset), keyword, orderby, descending, types, false);
                total = this.fetchClaimHandler.countClaimsByContext(contextId, keyword, types);
            }
            catch (SQLStoreException | Exception e) {
                logger.error((Object)("Could not fetch claims for context with id " + contextId), e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.compose500Message("Fail to fetch claims for context with id " + contextId + ".", e)).type("application/json").build();
            }
            return Response.status((int)200).entity((Object)this.composeDataResponse(request, claims, total, offset, limit)).build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access")).type("application/json").build();
    }

    @GET
    @Path(value="/results/{resultId}/claims")
    @Produces(value={"application/json"})
    public Response getResultClaims(@PathParam(value="resultId") String resultId, @DefaultValue(value="0") @QueryParam(value="offset") int offset, @DefaultValue(value="20") @QueryParam(value="limit") int limit, @DefaultValue(value="") @QueryParam(value="keyword") String keyword, @DefaultValue(value="") @QueryParam(value="sortby") String orderby, @DefaultValue(value="true") @QueryParam(value="descending") boolean descending, @DefaultValue(value="") @QueryParam(value="types") List<String> types, @HeaderParam(value="X-XSRF-TOKEN") String token, @CookieParam(value="AccessToken") String cookie, @Context HttpServletRequest request) {
        if (token == null || token.isEmpty() || cookie == null || cookie.isEmpty() || !cookie.equals(token)) {
            this.authorization.logStatus(token, cookie);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. Maybe you are not registered.")).type("application/json").build();
        }
        if (this.authorization.isClaimCurator(token)) {
            int total = -1;
            if (resultId == null || resultId.isEmpty()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.compose400Message("Context id cannot be empty.")).type("application/json").build();
            }
            List claims = null;
            try {
                claims = this.fetchClaimHandler.fetchClaimsByResult(resultId, Integer.valueOf(limit), Integer.valueOf(offset), keyword, orderby, descending, types, false);
                total = this.fetchClaimHandler.countClaimsByResult(resultId, keyword, types);
            }
            catch (SQLStoreException | Exception e) {
                logger.error((Object)("Could not fetch claims for result with id " + resultId), e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.compose500Message("Fail to fetch claims for result with id " + resultId + ".", e)).type("application/json").build();
            }
            return Response.status((int)200).entity((Object)this.composeDataResponse(request, claims, total, offset, limit)).build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access")).type("application/json").build();
    }

    @GET
    @Path(value="/users/claims")
    @Produces(value={"application/json"})
    public Response getUserClaims(@DefaultValue(value="0") @QueryParam(value="offset") int offset, @DefaultValue(value="20") @QueryParam(value="limit") int limit, @DefaultValue(value="") @QueryParam(value="keyword") String keyword, @DefaultValue(value="") @QueryParam(value="sortby") String orderby, @DefaultValue(value="true") @QueryParam(value="descending") boolean descending, @DefaultValue(value="") @QueryParam(value="types") List<String> types, @HeaderParam(value="X-XSRF-TOKEN") String token, @CookieParam(value="AccessToken") String cookie, @Context HttpServletRequest request) {
        if (token == null || token.isEmpty() || cookie == null || cookie.isEmpty() || !cookie.equals(token)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. Maybe you are not registered.")).type("application/json").build();
        }
        UserInfo userInfo = this.authorization.getUserHandler().getUserInfo(token);
        if (this.authorization.isRegistered(userInfo)) {
            String userMail = userInfo.getEmail();
            logger.debug((Object)"User is registerd ");
            int total = -1;
            EmailValidator emailValidator = EmailValidator.getInstance();
            if (userMail == null || userMail.isEmpty()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.compose400Message("User e-mail cannot be empty.")).type("application/json").build();
            }
            if (!emailValidator.isValid(userMail)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.compose400Message("User e-mail is not valid.")).type("application/json").build();
            }
            List claims = null;
            try {
                logger.debug((Object)"About to fetch claims");
                claims = this.fetchClaimHandler.fetchClaimsByUser(userMail, Integer.valueOf(limit), Integer.valueOf(offset), keyword, orderby, descending, types, false);
                total = this.fetchClaimHandler.countClaimsByUser(userMail, keyword, types);
            }
            catch (SQLStoreException | Exception e) {
                logger.error((Object)("Could not fetch claims for user with mail " + userMail), e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.compose500Message("Fail to fetch claims for user with e-mail " + userMail + ".", e)).type("application/json").build();
            }
            return Response.status((int)200).entity((Object)this.composeDataResponse(request, claims, total, offset, limit)).build();
        }
        logger.debug((Object)"User is *NOT* registerd ");
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. You are not registered.")).type("application/json").build();
    }

    @GET
    @Path(value="/claims/{claimId}")
    @Produces(value={"application/json"})
    public Response getClaimsById(@PathParam(value="claimId") String claimId, @DefaultValue(value="0") @QueryParam(value="offset") int offset, @DefaultValue(value="20") @QueryParam(value="limit") int limit, @HeaderParam(value="X-XSRF-TOKEN") String token, @CookieParam(value="AccessToken") String cookie, @Context HttpServletRequest request) {
        if (token == null || token.isEmpty() || cookie == null || cookie.isEmpty() || !cookie.equals(token)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. Maybe you are not registered.")).type("application/json").build();
        }
        if (this.authorization.isRegistered(token)) {
            List claims = null;
            int total = -1;
            if (claimId == null || claimId.isEmpty()) {
                try {
                    claims = this.fetchClaimHandler.fetchAllClaims(Integer.valueOf(limit), Integer.valueOf(offset), false);
                    total = this.fetchClaimHandler.countAllClaims("", new ArrayList());
                    return Response.status((int)200).entity((Object)this.composeDataResponse(request, claims, total, offset, limit)).type("application/json").build();
                }
                catch (SQLStoreException | Exception e) {
                    logger.error((Object)"Could not fetch claims.", e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.compose500Message("Fail to fetch claims.", e)).type("application/json").build();
                }
            }
            try {
                Claim claim = this.fetchClaimHandler.fetchClaimById(claimId, false);
                if (claim == null) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.compose404Message("Cannot find claim with id " + claimId + ".")).type("application/json").build();
                }
                return Response.status((int)200).entity((Object)this.composeDataResponse(claim)).build();
            }
            catch (SQLStoreException | Exception e) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.compose500Message("Fail to fetch claim with id " + claimId + " id.", e)).type("application/json").build();
            }
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. You are not registered.")).type("application/json").build();
    }

    @GET
    @Path(value="/claims")
    @Produces(value={"application/json"})
    public Response getAllClaims(@DefaultValue(value="0") @QueryParam(value="offset") int offset, @DefaultValue(value="20") @QueryParam(value="limit") int limit, @DefaultValue(value="") @QueryParam(value="keyword") String keyword, @DefaultValue(value="date") @QueryParam(value="sortby") String orderby, @DefaultValue(value="true") @QueryParam(value="descending") boolean descending, @DefaultValue(value="") @QueryParam(value="types") List<String> types, @HeaderParam(value="X-XSRF-TOKEN") String token, @HeaderParam(value="Origin") String origin, @CookieParam(value="AccessToken") String cookie, @Context HttpServletRequest request) {
        logger.debug((Object)("Header  \"Origin\" has value  " + origin));
        if (token == null || token.isEmpty() || cookie == null || cookie.isEmpty() || !cookie.equals(token)) {
            logger.debug((Object)"User is not  authorized - Eroor 403");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. Maybe you are not registered.")).type("application/json").build();
        }
        if (this.authorization.isClaimCurator(token)) {
            logger.debug((Object)"User is authorized ! !");
            List claims = null;
            int total = -1;
            try {
                claims = this.fetchClaimHandler.fetchAllClaims(Integer.valueOf(limit), Integer.valueOf(offset), keyword, orderby, descending, types, false);
                total = this.fetchClaimHandler.countAllClaims(keyword, types);
                return Response.status((int)200).entity((Object)this.composeDataResponse(request, claims, total, offset, limit)).build();
            }
            catch (SQLStoreException | Exception e) {
                logger.error((Object)"Could not fetch claims.", e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.compose500Message("Fail to fetch claims.", e)).type("application/json").build();
            }
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access")).type("application/json").build();
    }

    @DELETE
    @Path(value="/claims/bulk")
    @Produces(value={"application/json"})
    public Response deleteBulkClaims(@QueryParam(value="claimId") List<String> claimIds, @HeaderParam(value="X-XSRF-TOKEN") String token, @HeaderParam(value="Origin") String origin, @CookieParam(value="AccessToken") String cookie) {
        if (!this.authorization.hasBasicAuthorization(token, origin, cookie)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. Maybe you are not registered.")).type("application/json").build();
        }
        ArrayList<String> deletedIds = new ArrayList<String>();
        ArrayList<String> notFoundIds = new ArrayList<String>();
        if (claimIds == null || claimIds.size() == 0) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.compose404BulkDeleteMessage("Claim ids cannot be empty.", deletedIds, notFoundIds)).type("application/json").build();
        }
        logger.debug((Object)("Trying to delete claims with ids: " + claimIds.toString() + "."));
        UserInfo userInfo = this.authorization.getUserHandler().getUserInfo(token);
        for (String claimId : claimIds) {
            try {
                if (this.authorization.isRegistered(userInfo)) {
                    if (this.authorization.isClaimCurator(userInfo) || this.authorization.isCommunityCurator(userInfo) || userInfo.getEmail().equals(this.fetchClaimHandler.fetchClaimById(claimId, false).getUserMail())) {
                        if (this.claimHandler.deleteClaim(claimId)) {
                            deletedIds.add(claimId);
                            continue;
                        }
                        notFoundIds.add(claimId);
                        continue;
                    }
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to delete.")).type("application/json").build();
                }
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. Maybe you are not registered.")).type("application/json").build();
            }
            catch (SQLStoreException | Exception e) {
                logger.error((Object)("Fail to delete claim with id " + claimId + "."), e);
                notFoundIds.add(claimId);
            }
        }
        logger.debug((Object)("Successfully deleted " + deletedIds.size() + " from " + claimIds.size() + ". Deleted claims with ids: " + deletedIds.toString() + "."));
        if (claimIds.size() == notFoundIds.size()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.compose404BulkDeleteMessage("Claim ids cannot be empty.", deletedIds, notFoundIds)).type("application/json").build();
        }
        if (claimIds.size() == notFoundIds.size()) {
            return Response.status((int)204).entity((Object)this.compose204BulkDeleteMessage(deletedIds, notFoundIds)).type("application/json").build();
        }
        return Response.status((int)204).entity((Object)this.compose204BulkDeleteMessage(deletedIds, notFoundIds)).type("application/json").build();
    }

    @POST
    @Path(value="/claims")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response addClaim(String input, @Context HttpServletRequest request, @HeaderParam(value="X-XSRF-TOKEN") String token, @HeaderParam(value="Origin") String origin, @CookieParam(value="AccessToken") String cookie) {
        if (!this.authorization.hasBasicAuthorization(token, origin, cookie)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. Maybe you are not registered.")).type("application/json").build();
        }
        UserInfo userInfo = this.authorization.getUserHandler().getUserInfo(token);
        if (this.authorization.isRegistered(userInfo)) {
            JsonObject jsonObject = new JsonParser().parse(input).getAsJsonObject();
            String claimedBy = userInfo.getEmail();
            logger.info((Object)("claimedBy " + claimedBy));
            EmailValidator emailValidator = EmailValidator.getInstance();
            if (!emailValidator.isValid(claimedBy)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.compose400Message("User e-mail is invalid.")).type("application/json").build();
            }
            try {
                String claimId = this.getInfoAndBuildClaim(jsonObject, claimedBy);
                return Response.status((int)200).entity((Object)this.compose201PostMessage(request, claimId)).type("application/json").build();
            }
            catch (ClaimValidationException ve) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.compose400Message("The given ids are wrong.", (Exception)((Object)ve))).type("application/json").build();
            }
            catch (SQLStoreException | Exception e) {
                logger.error((Object)"Fail to add new claim.", e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.compose500Message("Fail to add new claim.", e)).type("application/json").build();
            }
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access.")).type("application/json").build();
    }

    @POST
    @Path(value="/claims/bulk")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response addBulkClaims(String input, @Context HttpServletRequest request, @HeaderParam(value="X-XSRF-TOKEN") String token, @HeaderParam(value="Origin") String origin, @CookieParam(value="AccessToken") String cookie) {
        if (!this.authorization.hasBasicAuthorization(token, origin, cookie)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. Maybe you are not registered.")).type("application/json").build();
        }
        UserInfo userInfo = this.authorization.getUserHandler().getUserInfo(token);
        if (this.authorization.isRegistered(userInfo)) {
            ArrayList<String> insertedIds = new ArrayList<String>();
            JsonArray errorInClaims = new JsonArray();
            int code200 = 0;
            int code400 = 0;
            int code500 = 0;
            JsonArray jsonArray = new JsonParser().parse(input).getAsJsonArray();
            for (JsonElement je : jsonArray) {
                JsonObject jsonObject = je.getAsJsonObject();
                String claimedBy = userInfo.getEmail();
                logger.info((Object)("claimedBy " + claimedBy));
                logger.debug((Object)jsonObject);
                EmailValidator emailValidator = EmailValidator.getInstance();
                if (!emailValidator.isValid(claimedBy)) {
                    jsonObject.addProperty("error", "user");
                    logger.error((Object)"no valid user");
                    ++code400;
                    errorInClaims.add((JsonElement)jsonObject);
                }
                try {
                    String claimId = this.getInfoAndBuildClaim(jsonObject, claimedBy);
                    insertedIds.add(claimId);
                    ++code200;
                }
                catch (ClaimValidationException ve) {
                    jsonObject.addProperty("error", "validation");
                    errorInClaims.add((JsonElement)jsonObject);
                    ++code400;
                }
                catch (SQLStoreException | Exception e) {
                    logger.error((Object)"Fail to add new claim.", e);
                    jsonObject.addProperty("error", "insertion");
                    errorInClaims.add((JsonElement)jsonObject);
                    ++code500;
                }
            }
            if (jsonArray.size() == code500) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.compose500BulkInsertMessage("Fail to add new claim.", insertedIds, errorInClaims)).type("application/json").build();
            }
            if (code200 > 0) {
                return Response.status((int)200).entity((Object)this.compose201BulkInsertMessage(insertedIds, errorInClaims)).type("application/json").build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.compose400BulkInsertMessage("The given ids are wrong.", insertedIds, errorInClaims)).type("application/json").build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. You are not registered.")).type("application/json").build();
    }

    @POST
    @Path(value="/curate/bulk")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response curateBulkClaims(String input, @Context HttpServletRequest request, @HeaderParam(value="X-XSRF-TOKEN") String token, @HeaderParam(value="Origin") String origin, @CookieParam(value="AccessToken") String cookie) {
        if (!this.authorization.hasBasicAuthorization(token, origin, cookie)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. Maybe you are not registered.")).type("application/json").build();
        }
        UserInfo userInfo = this.authorization.getUserHandler().getUserInfo(token);
        if (this.authorization.isRegistered(userInfo)) {
            ArrayList<String> insertedIds = new ArrayList<String>();
            JsonArray errorInClaims = new JsonArray();
            int code200 = 0;
            int code400 = 0;
            int code500 = 0;
            JsonArray jsonArray = new JsonParser().parse(input).getAsJsonArray();
            String curatedBy = userInfo.getEmail();
            for (JsonElement je : jsonArray) {
                JsonObject jsonObject = je.getAsJsonObject();
                String id = jsonObject.get("id").getAsString();
                logger.info((Object)("id " + id));
                Boolean approved = jsonObject.get("approved").getAsBoolean();
                logger.info((Object)("approved " + approved));
                EmailValidator emailValidator = EmailValidator.getInstance();
                if (!emailValidator.isValid(curatedBy)) {
                    jsonObject.addProperty("error", "user");
                    ++code400;
                    errorInClaims.add((JsonElement)jsonObject);
                }
                try {
                    this.claimHandler.updateClaimCurationInfo(curatedBy, id, approved.booleanValue());
                    insertedIds.add(id);
                    ++code200;
                }
                catch (SQLStoreException | Exception e) {
                    jsonObject.addProperty("error", "insertion");
                    errorInClaims.add((JsonElement)jsonObject);
                    ++code500;
                }
            }
            if (jsonArray.size() == code500) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.compose500BulkInsertMessage("Fail to update claims.", insertedIds, errorInClaims)).type("application/json").build();
            }
            if (code200 > 0) {
                return Response.status((int)200).entity((Object)this.compose201BulkInsertMessage(insertedIds, errorInClaims)).type("application/json").build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.compose400BulkInsertMessage("The given ids are wrong.", insertedIds, errorInClaims)).type("application/json").build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. You are not registered.")).type("application/json").build();
    }

    @POST
    @Path(value="/feed/bulk")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response feedBulkRecords(String input, @Context HttpServletRequest request, @HeaderParam(value="X-XSRF-TOKEN") String token, @HeaderParam(value="Origin") String origin, @CookieParam(value="AccessToken") String cookie) {
        if (!this.authorization.hasBasicAuthorization(token, origin, cookie)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. Maybe you are not registered.")).type("application/json").build();
        }
        if (this.authorization.isRegistered(token)) {
            ArrayList<String> insertedIds = new ArrayList<String>();
            JsonArray errorInClaims = new JsonArray();
            int code200 = 0;
            int code400 = 0;
            int code500 = 0;
            JsonArray jsonArray = new JsonParser().parse(input).getAsJsonArray();
            for (JsonElement je : jsonArray) {
                JsonObject jsonObject = je.getAsJsonObject();
                Boolean inserted = this.directIndexHandler.insertRecord(new Gson().toJson(jsonObject.get("record")));
                if (inserted.booleanValue()) {
                    insertedIds.add(jsonObject.get("id").getAsString());
                    ++code200;
                    continue;
                }
                errorInClaims.add(jsonObject.get("id").getAsString());
                ++code400;
            }
            if (jsonArray.size() == code500) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.compose500BulkInsertMessage("Fail to add new claim.", insertedIds, errorInClaims)).type("application/json").build();
            }
            if (code200 > 0) {
                return Response.status((int)200).entity((Object)this.compose201BulkInsertMessage(insertedIds, errorInClaims)).type("application/json").build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.compose400BulkInsertMessage("The given ids are wrong.", insertedIds, errorInClaims)).type("application/json").build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. You are not registered.")).type("application/json").build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GET
    @Path(value="/users/notification")
    @Produces(value={"application/json"})
    public Response getUserEmailNotificationPreferences(@QueryParam(value="communityId") String openaireId, @HeaderParam(value="X-XSRF-TOKEN") String token, @CookieParam(value="AccessToken") String cookie, @Context HttpServletRequest request) {
        if (token == null || token.isEmpty() || cookie == null || cookie.isEmpty() || !cookie.equals(token)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. Maybe you are not registered.")).type("application/json").build();
        }
        UserInfo userInfo = this.authorization.getUserHandler().getUserInfo(token);
        if (this.authorization.isRegistered(userInfo)) {
            String userMail = userInfo.getEmail();
            logger.debug((Object)"User is registerd ");
            EmailValidator emailValidator = EmailValidator.getInstance();
            if (userMail == null || userMail.isEmpty()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.compose400Message("User e-mail cannot be empty.")).type("application/json").build();
            }
            if (!emailValidator.isValid(userMail)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.compose400Message("User e-mail is not valid.")).type("application/json").build();
            }
            ArrayList<Notification> notifications = null;
            try {
                if (openaireId != null) {
                    if (!this.emailSender.getManagerUtils().isCommunityManager(openaireId, userMail).booleanValue() && !this.authorization.isCommunityCurator(userInfo)) return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. You are not registered.")).type("application/json").build();
                    Notification notification = null;
                    logger.debug((Object)"About to fetch notification");
                    notification = this.fetchNotificationHandler.fetchNotification(openaireId, userMail);
                    if (notification != null) {
                        notifications = new ArrayList<Notification>();
                        notification.setOpenaireName(openaireId);
                        notifications.add(notification);
                    }
                } else {
                    Map projectIdsAndNames = this.fetchProjectHandler.fetchProjectIdsAndNamesByProjectManagerMail(userMail);
                    if (projectIdsAndNames != null) {
                        for (Map.Entry projectIdAndName : projectIdsAndNames.entrySet()) {
                            Notification notification = null;
                            logger.debug((Object)"About to fetch notification");
                            notification = this.fetchNotificationHandler.fetchNotification((String)projectIdAndName.getKey(), userMail);
                            if (notifications == null) {
                                notifications = new ArrayList();
                            }
                            if (notification == null) {
                                notification = new Notification((String)projectIdAndName.getKey(), (String)projectIdAndName.getValue(), userMail, Integer.parseInt(this.defaultFrequencyInHours), true);
                            } else {
                                notification.setOpenaireName((String)projectIdAndName.getValue());
                            }
                            notifications.add(notification);
                            logger.debug((Object)notification);
                            logger.debug((Object)("notification openaireId:" + notification.getOpenaireId()));
                            logger.debug((Object)notifications.size());
                        }
                    }
                }
            }
            catch (SQLStoreException | Exception e) {
                logger.error((Object)("Could not fetch notification preferences for user with mail " + userMail), e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.compose500Message("Fail to fetch notification preferences for user with e-mail " + userMail + ".", e)).type("application/json").build();
            }
            if (notifications != null && !notifications.isEmpty()) return Response.status((int)200).entity((Object)this.composeDataResponse((List<Notification>)notifications)).build();
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.compose404Message("There are no notifications for user with mail " + userMail)).type("application/json").build();
        }
        logger.debug((Object)"User is *NOT* registerd ");
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. You are not registered.")).type("application/json").build();
    }

    @POST
    @Path(value="/users/notification/save")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response saveOrUpdateUserEmailNotificationPreferences(String input, @Context HttpServletRequest request, @HeaderParam(value="X-XSRF-TOKEN") String token, @HeaderParam(value="Origin") String origin, @CookieParam(value="AccessToken") String cookie) {
        if (!this.authorization.hasBasicAuthorization(token, origin, cookie)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. Maybe you are not registered.")).type("application/json").build();
        }
        UserInfo userInfo = this.authorization.getUserHandler().getUserInfo(token);
        if (this.authorization.isRegistered(userInfo)) {
            block14: {
                ArrayList insertedIds = new ArrayList();
                JsonArray errorInClaims = new JsonArray();
                boolean code200 = false;
                boolean code400 = false;
                boolean code500 = false;
                JsonObject jsonObject = new JsonParser().parse(input).getAsJsonObject();
                String userMail = userInfo.getEmail();
                String openaireId = jsonObject.get("openaireId").getAsString();
                logger.info((Object)("openaireId " + openaireId));
                boolean notify = jsonObject.get("notify").getAsBoolean();
                logger.info((Object)("notify " + notify));
                int frequency = jsonObject.get("frequency").getAsInt();
                logger.info((Object)("frequency " + frequency));
                EmailValidator emailValidator = EmailValidator.getInstance();
                if (!emailValidator.isValid(userMail)) {
                    jsonObject.addProperty("error", "user");
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.compose400Message("User e-mail is invalid.")).type("application/json").build();
                }
                try {
                    boolean continueProcedure = false;
                    List managers = null;
                    try {
                        managers = this.fetchProjectHandler.fetchContactEmailsByProjectId(openaireId);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    catch (SQLStoreException e) {
                        e.printStackTrace();
                    }
                    if (managers != null && managers.contains(userMail)) {
                        continueProcedure = true;
                    } else if (this.emailSender.getManagerUtils().isCommunityManager(openaireId, userMail).booleanValue() || this.authorization.isCommunityCurator(userInfo)) {
                        continueProcedure = true;
                    }
                    if (continueProcedure) {
                        Notification notification = null;
                        logger.debug((Object)"About to fetch notification");
                        notification = this.fetchNotificationHandler.fetchNotification(openaireId, userMail);
                        if (notification == null) {
                            logger.debug((Object)"About to insert notification");
                            this.notificationHandler.buildAndInsertNotification(openaireId, userMail, frequency, notify);
                        } else {
                            logger.debug((Object)"About to update notification");
                            this.notificationHandler.updateNotificationPreferences(openaireId, userMail, frequency, notify);
                        }
                        break block14;
                    }
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. You are not registered.")).type("application/json").build();
                }
                catch (SQLStoreException | Exception e) {
                    logger.error((Object)("Could not save or update notification preferences for user with mail " + userMail), e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.compose500Message("Fail to fetch notification preferences for user with e-mail " + userMail + ".", e)).type("application/json").build();
                }
            }
            return Response.status((int)200).entity((Object)this.compose200Message("Save or Update for notification successful")).type("application/json").build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.compose403Message("Forbidden: You don't have permission to access. You are not registered.")).type("application/json").build();
    }

    private String xml2Json(List<String> input) {
        StringBuilder builder = new StringBuilder();
        for (String category : input) {
            builder.append(category);
        }
        return builder.toString();
    }

    private String compose200Message(String message) {
        return " { \"status\" : \"success\", \"code\": \"200\", \"message\" : \"  " + message + " \" }";
    }

    private String compose204Message(String message) {
        return "{ \"status\" : \"error\", \"code\" : \"204\", \"message\" : \"  " + message + " \" }";
    }

    private String compose400Message(String message) {
        return "{ \"status\" : \"error\", \"code\" : \"400\", \"message\" : \"  " + message + " \" }";
    }

    private String compose400Message(String message, Exception exception) {
        return "{ \"status\" : \"error\", \"code\" : \"400\", \"message\" : \"  " + message + "\", \"description\" : \"" + exception.getMessage() + "\" }";
    }

    private String compose403Message(String message) {
        return "{ \"status\" : \"error\", \"code\" : \"403\", \"message\" : \"  " + message + "\", \"description\" : \"\" }";
    }

    private String compose404BulkDeleteMessage(String message, List<String> deletedIds, List<String> notFoundIds) {
        return "{ \"status\" : \"error\", \"code\" : \"404\", \"message\" : \"  " + message + " \",\"deletedIds\" : " + new Gson().toJson(deletedIds) + ",\"notFoundIds\" : " + new Gson().toJson(notFoundIds) + " }";
    }

    private String compose404Message(String message) {
        return "{ \"status\" : \"error\", \"code\" : \"404\", \"message\" : \"  " + message + " \" }";
    }

    private String compose400BulkInsertMessage(String message, List<String> insertedIds, JsonArray errorInClaims) {
        return "{ \"status\" : \"error\", \"code\" : \"400\", \"message\" : \"  " + message + " \", \"insertedIds\" : " + new Gson().toJson(insertedIds) + ",\"errorInClaims\" : " + new Gson().toJson((JsonElement)errorInClaims) + " }";
    }

    private String compose500Message(String message, Throwable throwable) {
        return "{ \"status\" : \"fail\", \"code\" : \"500\", \"message\" : \"  " + message + "\", \"description\" : \"" + throwable.getMessage() + "\" }";
    }

    private String compose500BulkInsertMessage(String message, List<String> insertedIds, JsonArray errorInClaims) {
        return "{ \"status\" : \"fail\", \"code\" : \"500\", \"message\" : \"  " + message + "\", \"description\" : \"\" , \"insertedIds\" : " + new Gson().toJson(insertedIds) + ",\"errorInClaims\" : " + new Gson().toJson((JsonElement)errorInClaims) + " }";
    }

    private String compose204BulkDeleteMessage(List<String> deletedIds, List<String> notFoundIds) {
        return " { \"status\" : \"success\", \"code\": \"204\", \"deletedIds\" : " + new Gson().toJson(deletedIds) + ",\"notFoundIds\" : " + new Gson().toJson(notFoundIds) + "}";
    }

    private String compose201PostMessage(@Context HttpServletRequest request, String claimId) {
        String url = request.getRequestURL().toString();
        return " { \"status\" : \"success\", \"code\": \"201\", \"link\": \"" + url + "/" + claimId + "\" }";
    }

    private String compose201BulkInsertMessage(List<String> insertedIds, JsonArray errorInClaims) {
        return " { \"status\" : \"success\", \"code\": \"201\",\"insertedIds\" : " + new Gson().toJson(insertedIds) + ",\"errorInClaims\" : " + new Gson().toJson((JsonElement)errorInClaims) + "}";
    }

    private String composeDataResponse(HttpServletRequest request, List<Claim> claims, int total, int offset, int limit) {
        if (offset != -1 && limit != -1) {
            return " { \"status\" : \"success\", \"code\": \"200\",  " + this.composeTotalResults(total) + ", " + ClaimsService.composePaging(request, total, offset, limit) + ", \"data\" : " + new Gson().toJson(claims) + " }";
        }
        return " { \"status\" : \"success\", \"code\": \"200\",  " + this.composeTotalResults(total) + ", \"data\" : " + new Gson().toJson(claims) + " }";
    }

    private String composeDataResponse(String xml) {
        return " { \"status\" : \"success\", \"code\": \"200\", \"data\" : " + XML.toJSONObject((String)xml).toString() + " }";
    }

    private String composeDataResponse(Claim claim) {
        return " { \"status\" : \"success\", \"code\": \"200\", \"data\" : " + new Gson().toJson((Object)claim) + " }";
    }

    private String composeDataResponse(List<Notification> notifications) {
        return " { \"status\" : \"success\", \"code\": \"200\", \"data\" : " + new Gson().toJson(notifications) + " }";
    }

    private static String composePaging(HttpServletRequest request, int total, int currentOffset, int limit) {
        logger.info((Object)("total " + total));
        logger.info((Object)("currentOffset " + currentOffset));
        logger.info((Object)("limit " + limit));
        String url = request.getRequestURL().toString();
        String first = url + "?offset=0&limit=20";
        int lastPage = total <= limit ? 0 : (total % limit == 0 ? total / limit - 1 : total / limit);
        String last = url + "?offset=" + lastPage + "&limit=20";
        int previousPage = currentOffset - 1 <= 0 ? 0 : currentOffset - 1;
        String previous = url + "?offset=" + previousPage + "&limit=20";
        int nextPage = currentOffset + 1 >= lastPage ? lastPage : currentOffset + 1;
        String next = url + "?offset=" + nextPage + "&limit=20";
        return "\"paging\": [{\"rel\":\"first\", \"href\":\"" + first + "\"}, {\"rel\":\"last\", \"href\":\"" + last + "\"}, {\"rel\":\"previous\", \"href\": \"" + previous + "\"}, {\"rel\":\"next\", \"href\":\"" + next + "\"}]";
    }

    private String composeTotalResults(int total) {
        return "\"total\": \"" + total + "\"";
    }

    public static void main(String[] args) {
    }

    @GET
    @Path(value="test-email")
    public void testEmail() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("konstantinagalouni@gmail.com");
        list.add("argirok@di.uoa.gr");
        this.emailSender.send("openaire_id_test", "openaire_name_test", "community", list);
    }

    private String getvalueOf(JsonObject jsonObject, String field) {
        String value = jsonObject.get(field) != null && !jsonObject.get(field).isJsonNull() ? jsonObject.get(field).getAsString() : null;
        logger.info((Object)(field + ": " + value));
        return value;
    }

    private String getvalueOfDefault(JsonObject jsonObject, String field, String defaultValue) {
        String value = this.getvalueOf(jsonObject, field);
        logger.debug((Object)("Field:" + field + "->" + value + "<-"));
        return value != null && !value.equals("") ? value : defaultValue;
    }

    private String getInfoAndBuildClaim(JsonObject jsonObject, String claimedBy) throws SQLStoreException, Exception {
        String claimedInDashboard = this.getvalueOfDefault(jsonObject, "claimedInDashboard", null);
        String sourceId = this.getvalueOf(jsonObject, "sourceId");
        String sourceType = this.getvalueOf(jsonObject, "sourceType");
        String sourceCollectedFrom = this.getvalueOf(jsonObject, "sourceCollectedFrom");
        String sourceAccessRights = this.getvalueOf(jsonObject, "sourceAccessRights");
        String sourceEmbargoEndDate = this.getvalueOfDefault(jsonObject, "sourceEmbargoEndDate", null);
        String targetId = this.getvalueOf(jsonObject, "targetId");
        String targetType = this.getvalueOf(jsonObject, "targetType");
        String targetCollectedFrom = this.getvalueOf(jsonObject, "targetCollectedFrom");
        String targetAccessRights = this.getvalueOf(jsonObject, "targetAccessRights");
        String targetEmbargoEndDate = this.getvalueOfDefault(jsonObject, "targetEmbargoEndDate", null);
        logger.debug((Object)("Claimed in" + claimedInDashboard));
        return this.claimHandler.buildAndInsertClaim(claimedBy, sourceType, sourceId, sourceCollectedFrom, sourceAccessRights, sourceEmbargoEndDate, targetType, targetId, targetCollectedFrom, targetAccessRights, targetEmbargoEndDate, claimedInDashboard);
    }
}

