package eu.dnetlib.clients.functionality.profile.ws;

import org.apache.log4j.Logger;

import eu.dnetlib.api.functionality.UserProfileService;
import eu.dnetlib.domain.functionality.UserProfile;
import eu.dnetlib.utils.resolver.ServiceClientFactory;
import gr.uoa.di.driver.enabling.ISLookUp;
import gr.uoa.di.driver.enabling.islookup.ISLookUpFactory;

public class UserProfileServiceClientFactory implements ServiceClientFactory<UserProfileService> {
	private static Logger logger = Logger.getLogger(UserProfileServiceClientFactory.class);
	
	private ISLookUpFactory lookUpFactory = null;
	
	@Override
	public UserProfileService newClient(Object endpoint) {
		try {
			CheatingWSClient client = new CheatingWSClient();
			ISLookUp<UserProfile> userLookUp = lookUpFactory.createISLookUp(UserProfile.class);
			
			client.setUserLookup(userLookUp);
			client.setWebService(endpoint);
			
			return client;
		} catch (Exception e) {
			logger.error("Error creating factory for profile service", e);
			return null;
		}
	}

	public ISLookUpFactory getLookUpFactory() {
		return lookUpFactory;
	}

	public void setLookUpFactory(ISLookUpFactory lookUpFactory) {
		this.lookUpFactory = lookUpFactory;
	}
}