package eu.dnetlib.clients.functionality.profile.ws;

import java.util.List;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;

import eu.dnetlib.api.functionality.UserProfileService;
import eu.dnetlib.clients.ws.DriverWebService;
import eu.dnetlib.domain.functionality.UserProfile;
import eu.dnetlib.domain.functionality.UserProfileSearchCriteria;

/**
 * Interface of the UserProfile Web Service
 * 
 * @author <a href="mailto:kiatrop@di.uoa.gr">Katerina Iatropoulou</a>
 * 
 */
@WebService
public interface UserProfileWebService extends
		DriverWebService<UserProfileService> {
	
	@WebMethod(operationName="saveUser")
	public UserProfile saveUser(
			@WebParam(name="profile") UserProfile profile)
			throws UserProfileWebServiceException;

	@WebMethod(operationName="deleteUser")
	public void deleteUser(
			@WebParam(name="profile") UserProfile profile)
			throws UserProfileWebServiceException;

	@WebMethod(operationName="deleteUserById")
	public void deleteUserById(
			@WebParam(name="id") String id) throws UserProfileWebServiceException;
	
	@WebMethod(operationName="getUserById")
	public UserProfile getUserById(
			@WebParam(name="id") String id)	throws UserProfileWebServiceException;

	@WebMethod(operationName="searchUsers")
	public List<UserProfile> searchUsers(
			@WebParam(name="criteria") UserProfileSearchCriteria criteria)
			throws UserProfileWebServiceException;

	@WebMethod(operationName="searchUserIds")
	public List<String> searchUserIds(
			@WebParam(name="userIds") UserProfileSearchCriteria criteria)
			throws UserProfileWebServiceException;
}