package eu.dnetlib.clients.functionality.validator.ws;

import java.util.List;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;

import eu.dnetlib.api.functionality.ValidatorService;
import eu.dnetlib.api.functionality.ValidatorServiceException;
import eu.dnetlib.clients.ws.DriverWebService;
import eu.dnetlib.domain.functionality.validator.JobForValidation;
import eu.dnetlib.domain.functionality.validator.RuleSet;
import eu.dnetlib.domain.functionality.validator.StoredJob;

@WebService (targetNamespace ="http://services.dnetlib.eu/")
public interface ValidatorWebService extends DriverWebService<ValidatorService> {

	@WebMethod(operationName = "getStoredJob")
	StoredJob getStoredJob(@WebParam(name = "jobId") int jobId, @WebParam(name = "groupBy") String groupBy) throws ValidatorServiceException;

	@WebMethod(operationName = "getStoredJobs")
	List<StoredJob> getStoredJobs(@WebParam(name = "userMail") String userMail, @WebParam(name = "jobType") String jobType, @WebParam(name = "offset") Integer offset, @WebParam(name = "limit") Integer limit, @WebParam(name = "dateFrom") String dateFrom, @WebParam(name = "dateTo") String dateTo) throws ValidatorServiceException;

	@WebMethod(operationName = "getStoredJobsTotalNumber")
	int getStoredJobsTotalNumber(@WebParam(name = "userMail") String userMail, @WebParam(name = "jobType") String jobType) throws ValidatorServiceException;

	@WebMethod(operationName = "getStoredJobsNew")
	List<StoredJob> getStoredJobsNew(@WebParam(name = "userMail") String userMail, @WebParam(name = "jobType") String jobType, @WebParam(name = "offset") Integer offset, @WebParam(name = "limit") Integer limit, @WebParam(name = "dateFrom") String dateFrom, @WebParam(name = "dateTo") String dateTo, @WebParam(name = "jobStatus") String jobStatus) throws ValidatorServiceException;

	@WebMethod(operationName = "getStoredJobsTotalNumberNew")
	int getStoredJobsTotalNumberNew(@WebParam(name = "userMail") String userMail, @WebParam(name = "jobType") String jobType, @WebParam(name = "jobStatus") String jobStatus) throws ValidatorServiceException;

	@WebMethod(operationName = "getRuleSets")
	List<RuleSet> getRuleSets() throws ValidatorServiceException;
	
	@WebMethod(operationName = "submitValidationJob")
	void submitValidationJob(@WebParam(name = "job")JobForValidation job) throws ValidatorServiceException;

}