package eu.dnetlib.clients.functionality.forum.ws;

import java.util.ArrayList;
import java.util.List;

import javax.jws.WebService;

import eu.dnetlib.api.functionality.ForumService;
import eu.dnetlib.api.functionality.ForumServiceException;
import eu.dnetlib.clients.ws.BaseDriverWebService;
import eu.dnetlib.domain.functionality.Post;
import eu.dnetlib.domain.functionality.Thread;

/**
 * This class implements forum web service using a forum service.
 * @author thanos@di.uoa.gr
 *
 */
@WebService(
		serviceName = "ForumWebService", 
		endpointInterface = "eu.dnetlib.clients.functionality.forum.ws.ForumWebService")
public class ForumWebServiceImpl 
		extends BaseDriverWebService<ForumService> 
		implements ForumWebService {
	
	@Override
	public void deleteThread(long threadId) throws ForumWebServiceException {
		try {
			service.deleteThread(threadId);
		} catch (ForumServiceException e) {
			throw new ForumWebServiceException(e);
		}
	}

	@Override
	public void editThread(long threadId, String topic, List<Post> posts) throws ForumWebServiceException {
		try {
			if (posts == null)
				posts = new ArrayList<Post>();
			service.editThread(threadId, topic, posts);
		} catch (ForumServiceException e) {
			throw new ForumWebServiceException(e);
		}
	}

	@Override
	public long openThread(String communityId, String userId, String topic) throws ForumWebServiceException {
		try {
			return service.openThread(communityId, userId, topic);
		} catch (ForumServiceException e) {
			throw new ForumWebServiceException(e);
		}
	}

	@Override
	public Thread searchThread(long threadId) throws ForumWebServiceException {
		try {
			return service.searchThread(threadId);
		} catch (ForumServiceException e) {
			throw new ForumWebServiceException(e);
		}
	}

	@Override
	public List<Thread> searchThread(String communityId) throws ForumWebServiceException {
		try {
			return service.searchThread(communityId);
		} catch (ForumServiceException e) {
			throw new ForumWebServiceException(e);
		}
	}
}
