/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.clients.utils.ws;

import eu.dnetlib.api.DriverService;
import eu.dnetlib.clients.utils.ws.CompatibilityTransportConfiguration;
import eu.dnetlib.utils.resolver.ServiceClientFactory;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;

public class CompatibilityServiceClientFactory<S extends DriverService>
implements ServiceClientFactory<S> {
    private CompatibilityTransportConfiguration config = null;
    private static Logger logger = Logger.getLogger(CompatibilityServiceClientFactory.class);
    private Class<S> serviceClass = null;

    public S newClient(Object endpoint) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating client for service " + this.serviceClass.getName() + " and endpoint of class " + endpoint.getClass().getName()));
        }
        try {
            Class<S> clientClass = this.config.getServiceClientClass(this.serviceClass);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("client class: " + clientClass.getName()));
            }
            DriverService client = (DriverService)clientClass.newInstance();
            clientClass.getMethod("setWebService", Object.class).invoke((Object)client, endpoint);
            return (S)client;
        }
        catch (InstantiationException e) {
            logger.error((Object)"Error creating service client", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"Error creating service client", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)"Error creating service client", (Throwable)e);
        }
        catch (SecurityException e) {
            logger.error((Object)"Error creating service client", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.error((Object)"Error creating service client", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)"Error creating service client", (Throwable)e);
        }
        return null;
    }

    public CompatibilityTransportConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(CompatibilityTransportConfiguration config) {
        this.config = config;
    }

    public Class<S> getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(Class<S> serviceClass) {
        this.serviceClass = serviceClass;
    }
}

