/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.clients.utils.ws;

import eu.dnetlib.api.DriverService;
import eu.dnetlib.common.rmi.BaseService;
import eu.dnetlib.enabling.is.store.rmi.ISStoreService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.utils.resolver.ServiceClientFactory;
import eu.dnetlib.utils.resolver.TransportConfiguration;
import gr.uoa.di.driver.util.ServiceLocator;
import org.apache.log4j.Logger;

public class CompatibilityServiceLocator<S extends DriverService>
implements ServiceLocator<S> {
    private static Logger logger = Logger.getLogger(CompatibilityServiceLocator.class);
    private UniqueServiceLocator serviceLocator;
    private Class<S> serviceClass = null;
    TransportConfiguration transportConfiguration = null;
    private ServiceClientFactory<S> clientFactory = null;

    public S getService() {
        logger.debug((Object)("Locating service of type : " + this.serviceClass.getName()));
        DriverService service = null;
        try {
            Class endpointClass = this.transportConfiguration.getEndpointClass(this.serviceClass);
            BaseService endpoint = this.serviceLocator.getService(ISStoreService.class);
            logger.debug((Object)("Found service endpoint of type: " + endpoint.getClass().getName()));
            service = this.clientFactory.newClient((Object)endpoint);
        }
        catch (Exception e) {
            logger.debug((Object)"Failed to find service", (Throwable)e);
        }
        return (S)service;
    }

    public UniqueServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    public void setServiceLocator(UniqueServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    public Class<S> getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(Class<S> serviceClass) {
        this.serviceClass = serviceClass;
    }

    public void setClientFactory(ServiceClientFactory<S> clientFactory) {
        this.clientFactory = clientFactory;
    }
}

