package eu.dnetlib.clients.data.search.ws;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import eu.dnetlib.domain.data.SuggestiveResult;
import eu.dnetlib.utils.EPRUtils;

public class SuggestiveWebResult {

	private W3CEndpointReference epr = null;
	private String alternativeTerm = null;
	private boolean autofollow = false;

	public SuggestiveWebResult() {
	}

	public SuggestiveWebResult(SuggestiveResult res) {
		this.epr = EPRUtils.createW3CEPR(res.getEpr());
		this.alternativeTerm = res.getAlternativeTerm();
		this.autofollow = res.isAutofollow();
	}

	public SuggestiveWebResult(W3CEndpointReference epr,
			String alternativeTerm, boolean autofollow) {
		super();
		this.epr = epr;
		this.alternativeTerm = alternativeTerm;
		this.autofollow = autofollow;
	}

	public SuggestiveResult toSuggestiveResult() {
		SuggestiveResult res = new SuggestiveResult();

		res.setEpr(EPRUtils.createEPR(this.epr));
		res.setAlternativeTerm(this.alternativeTerm);
		res.setAutofollow(this.autofollow);

		return res;
	}

	public W3CEndpointReference getEpr() {
		return epr;
	}

	public void setEpr(W3CEndpointReference epr) {
		this.epr = epr;
	}

	public String getAlternativeTerm() {
		return alternativeTerm;
	}

	public void setAlternativeTerm(String alternativeTerm) {
		this.alternativeTerm = alternativeTerm;
	}

	public boolean isAutofollow() {
		return autofollow;
	}

	public void setAutofollow(boolean autofollow) {
		this.autofollow = autofollow;
	}
}
