package eu.dnetlib.clients.functionality.forum.ws;

import java.util.ArrayList;
import java.util.List;

import eu.dnetlib.api.functionality.ForumService;
import eu.dnetlib.api.functionality.ForumServiceException;
import eu.dnetlib.clients.ws.BaseWebServiceClient;
import eu.dnetlib.domain.functionality.Post;
import eu.dnetlib.domain.functionality.Thread;

/**
 * This class implements forum service using a forum web service.
 * @author thanos@di.uoa.gr
 *
 */
public class ForumWebServiceClient
		extends BaseWebServiceClient<ForumWebService>
		implements ForumService {
	
	@Override
	public void deleteThread(long threadId) throws ForumServiceException {
		try {
			webService.deleteThread(threadId);
		} catch (ForumWebServiceException e) {
			throw new ForumServiceException(e);
		}
	}

	@Override
	public void editThread(long threadId, String topic, List<Post> posts) throws ForumServiceException {
		try {
			webService.editThread(threadId, topic, posts);
		} catch (ForumWebServiceException e) {
			throw new ForumServiceException(e);
		}
	}

	@Override
	public long openThread(String communityId, String userId, String topic) throws ForumServiceException {
		try {
			return webService.openThread(communityId, userId, topic);
		} catch (ForumWebServiceException e) {
			throw new ForumServiceException(e);
		}
	}

	@Override
	public Thread searchThread(long threadId) throws ForumServiceException {
		try {
			Thread thread = webService.searchThread(threadId);
			if (thread.getPosts() == null)
				thread.setPosts(new ArrayList<Post>());
			return thread;
		} catch (ForumWebServiceException e) {
			throw new ForumServiceException(e);
		}
	}

	@Override
	public List<Thread> searchThread(String communityId) throws ForumServiceException {
		try {
			List<Thread> result = webService.searchThread(communityId);
			if (result == null)
				return new ArrayList<Thread>();
			for (Thread thread : result) {
				if (thread.getPosts() == null)
					thread.setPosts(new ArrayList<Post>());
			}
			return result;
		} catch (ForumWebServiceException e) {
			throw new ForumServiceException(e);
		}
	}
}
