package eu.dnetlib.clients.functionality.forum.ws;

import eu.dnetlib.clients.ws.DriverWebServiceException;

/**
 * This exception is thrown by forum web service on any error.
 * @author thanos@di.uoa.gr
 *
 */
public class ForumWebServiceException extends DriverWebServiceException {

	/**
	 * Used for serialization / deserialization
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * Create a new forum web service exception.
	 */
	public ForumWebServiceException() {
		super();
	}
	
	/**
	 * Create a new forum web service exception with the specified error message.
	 * @param message the error message
	 */
	public ForumWebServiceException(String message) {
		super(message);
	}
	
	/**
	 * Create a new forum web service exception with the specified cause.
	 * @param cause the cause
	 */
	public ForumWebServiceException(Throwable cause) {
		super(cause);
	}
	
	/**
	 * Create a new forum web service exception with the specified error message and cause.
	 * @param message the error message
	 * @param cause the cause
	 */
	public ForumWebServiceException(String message, Throwable cause) {
		super(message, cause);
	}
}
