package eu.dnetlib.clients.functionality.notification.ws;

import java.net.URL;
import java.util.Date;
import java.util.SortedSet;

import javax.jws.WebService;

import eu.dnetlib.api.functionality.NotificationService;
import eu.dnetlib.api.functionality.NotificationServiceException;
import eu.dnetlib.clients.ws.BaseDriverWebService;
import eu.dnetlib.domain.functionality.NotificationEvent;
import eu.dnetlib.domain.functionality.NotificationQuery;
import eu.dnetlib.domain.functionality.NotificationResult;
import eu.dnetlib.domain.functionality.NotificationSchedule;
import eu.dnetlib.domain.functionality.NotificationSubscription;
import eu.dnetlib.domain.functionality.ObjectPage;
import eu.dnetlib.domain.functionality.ResultPage;

/**
 * This class implements notification web service using a plain notification service.
 * @author thanos@di.uoa.gr
 * @see NotificationWebService
 * @see eu.dnetlib.api.functionality.NotificationService
 * @see NotificationWebServiceException
 *
 */
@WebService(serviceName = "NotificationWebService", endpointInterface = "eu.dnetlib.clients.functionality.notification.ws.NotificationWebService")
public class NotificationWebServiceImpl extends BaseDriverWebService<NotificationService> implements NotificationWebService {
	@Override
	public SortedSet<String> getSupportedQueryLanguages() {
		return service.getSupportedQueryLanguages();
	}

	@Override
	public ObjectPage<NotificationQuery> getQueries(final int pageNumber, final int pageSize) throws NotificationWebServiceException {
		try {
			return service.getQueries(pageNumber, pageSize);
		} catch (final NotificationServiceException e) {
			throw new NotificationWebServiceException("error retrieving queries (page " + pageNumber + ", page size " + pageSize + ")", e);
		}
	}
	
	@Override
	public void addQuery(final NotificationQuery query) throws NotificationWebServiceException {
		try {
			service.addQuery(query);
		} catch (final NotificationServiceException e) {
			throw new NotificationWebServiceException("error adding query " + query, e);
		}
	}
	
	@Override
	public void removeQuery(final String queryId) throws NotificationWebServiceException {
		try {
			service.removeQuery(queryId);
		} catch (final NotificationServiceException e) {
			throw new NotificationWebServiceException("error removing query " + queryId, e);
		}
	}
	
	@Override
	public ResultPage executeQuery(final String queryId, final String resultId, final Date fromDate, final Date toDate, final int limit, final int offset) throws NotificationWebServiceException {
		try {
			return service.executeQuery(queryId, resultId, fromDate, toDate, limit, offset);
		} catch (final NotificationServiceException e) {
			throw new NotificationWebServiceException("error executing query " + queryId + " (result: " + resultId + ", from date: " + fromDate + ", to date: " + toDate + ", limit: " + limit + ", offset: " + offset + ")", e);
		}
	}
	
	@Override
	public ObjectPage<NotificationSchedule> getSchedules(final int pageNumber, final int pageSize) throws NotificationWebServiceException {
		try {
			return service.getSchedules(pageNumber, pageSize);
		} catch (final NotificationServiceException e) {
			throw new NotificationWebServiceException("error retrieving schedules (page: " + pageNumber + ", page size: " + pageSize + ")", e);
		}
	}
	
	@Override
	public void addSchedule(final NotificationSchedule schedule) throws NotificationWebServiceException {
		try {
			service.addSchedule(schedule);
		} catch (final NotificationServiceException e) {
			throw new NotificationWebServiceException("error adding schedule " + schedule, e);
		}
	}
	
	@Override
	public void enableSchedule(final String queryId) throws NotificationWebServiceException {
		try {
			service.enableSchedule(queryId);
		} catch (final NotificationServiceException e) {
			throw new NotificationWebServiceException("error enabling schedule " + queryId, e);
		}
	}

	@Override
	public void disableSchedule(final String queryId) throws NotificationWebServiceException {
		try {
			service.disableSchedule(queryId);
		} catch (final NotificationServiceException e) {
			throw new NotificationWebServiceException("error disabling schedule " + queryId, e);
		}
	}
	
	@Override
	public void removeSchedule(final String queryId) throws NotificationWebServiceException {
		try {
			service.removeQuery(queryId);
		} catch (final NotificationServiceException e) {
			throw new NotificationWebServiceException("error removing schedule " + queryId, e);
		}
	}

	@Override
	public ObjectPage<NotificationEvent> getEvents(final int pageNumber, final int pageSize) throws NotificationWebServiceException {
		try {
			return service.getEvents(pageNumber, pageSize);
		} catch (NotificationServiceException e) {
			throw new NotificationWebServiceException("error retrieving events (page: " + pageNumber + ", page size: " + pageSize + ")", e);
		}
	}
	
	@Override
	public ObjectPage<NotificationResult> getResults(final int pageNumber, final int pageSize) throws NotificationWebServiceException {
		try {
			return service.getResults(pageNumber, pageSize);
		} catch (NotificationServiceException e) {
			throw new NotificationWebServiceException("error retrieving results (page: " + pageNumber + ", page size: " + pageSize + ")", e);
		}
	}
	
	@Override
	public NotificationResult getResult(final String queryId, final Date date, final String resultId) throws NotificationWebServiceException {
		try {
			return service.getResult(queryId, date, resultId);
		} catch (final NotificationServiceException e) {
			throw new NotificationWebServiceException("error retrieving result " + resultId + " of event " + date + " of query " + queryId);
		}
	}
	
	@Override
	public NotificationResult getPreviousResult(final String queryId, final Date date, final String resultId) throws NotificationWebServiceException {
		try {
			return service.getPreviousResult(queryId, date, resultId);
		} catch (final NotificationServiceException e) {
			throw new NotificationWebServiceException("error retrieving result " + resultId + " of the previous event of event " + date + " of query " + queryId);
		}
	}
	
	@Override
	public ObjectPage<NotificationSubscription> getSubscriptions(final int pageSize, final int pageNumber) throws NotificationWebServiceException {
		try {
			return service.getSubscriptions(pageNumber, pageSize);
		} catch (final NotificationServiceException e) {
			throw new NotificationWebServiceException("error retrieving subscriptions (page: " + pageNumber + ", page size: " + pageSize + ")", e);
		}
	}
	
	@Override
	public void addSubscription(final NotificationSubscription subscription) throws NotificationWebServiceException {
		try {
			service.addSubscription(subscription);
		} catch (final NotificationServiceException e) {
			throw new NotificationWebServiceException("error adding subscription " + subscription, e);
		}
	}
	
	@Override
	public void enableSubscription(final String queryId, final URL alertService) throws NotificationWebServiceException {
		try {
			service.enableSubscription(queryId, alertService);
		} catch (final NotificationServiceException e) {
			throw new NotificationWebServiceException("error enabling subscription (query: " + queryId + ", alert service: " + alertService + ")", e);
		}
	}
	
	@Override
	public void disableSubscription(final String queryId, final URL alertService) throws NotificationWebServiceException {
		try {
			service.disableSubscription(queryId, alertService);
		} catch (final NotificationServiceException e) {
			throw new NotificationWebServiceException("error disabling subscription (query: " + queryId + ", alert service: " + alertService + ")", e);
		}
	}
	
	@Override
	public void removeSubscription(final String queryId, final URL alertService) throws NotificationWebServiceException {
		try {
			service.removeSubscription(queryId, alertService);
		} catch (final NotificationServiceException e) {
			throw new NotificationWebServiceException("error removing subscription (query: " + queryId + ", alert service: " + alertService + ")", e);
		}
	}
}
