package eu.dnetlib.clients.functionality.profile.ws;

import java.util.List;

import javax.jws.WebService;

import eu.dnetlib.api.functionality.UserProfileService;
import eu.dnetlib.api.functionality.UserProfileServiceException;
import eu.dnetlib.clients.ws.BaseDriverWebService;
import eu.dnetlib.domain.functionality.UserProfile;
import eu.dnetlib.domain.functionality.UserProfileSearchCriteria;

/**
 * Implements the methods of the User Profile Web Service
 * 
 * @author <a href="mailto:kiatrop@di.uoa.gr">Katerina Iatropoulou</a>
 * 
 */
@WebService(
	serviceName = "UserProfileWebService", 
	endpointInterface = "eu.dnetlib.clients.functionality.profile.ws.UserProfileWebService")
public class UserProfileWebServiceImpl
		extends BaseDriverWebService<UserProfileService>
		implements UserProfileWebService {

	@Override
	public void deleteUser(UserProfile profile)
			throws UserProfileWebServiceException {
		try {
			service.deleteUserById(profile.getResourceId());
		} catch (UserProfileServiceException e) {
			throw new UserProfileWebServiceException(e);
		}
	}

	@Override
	public void deleteUserById(String id) throws UserProfileWebServiceException {
		try {
			service.deleteUserById(id);
		} catch (UserProfileServiceException e) {
			throw new UserProfileWebServiceException(e);
		}
	}


	@Override
	public UserProfile getUserById(String id)
			throws UserProfileWebServiceException {
		try {
			return service.getUserById(id);
		} catch (UserProfileServiceException e) {
			throw new UserProfileWebServiceException(e);
		}
	}


	@Override
	public UserProfile saveUser(UserProfile profile)
			throws UserProfileWebServiceException {
		try {
			return service.saveUser(profile);
		} catch (UserProfileServiceException e) {
			throw new UserProfileWebServiceException(e);
		}
	}


	@Override
	public List<String> searchUserIds(UserProfileSearchCriteria criteria)
			throws UserProfileWebServiceException {
		try {
			return service.searchUserIds(criteria);
		} catch (UserProfileServiceException e) {
			throw new UserProfileWebServiceException(e);
		}
	}


	@Override
	public List<UserProfile> searchUsers(UserProfileSearchCriteria criteria)
			throws UserProfileWebServiceException {
		try {
			return service.searchUsers(criteria);
		} catch (UserProfileServiceException e) {
			throw new UserProfileWebServiceException(e);
		}
	}
}