/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.clients.functionality.alert.ws;

import eu.dnetlib.api.functionality.AlertService;
import eu.dnetlib.api.functionality.AlertServiceException;
import eu.dnetlib.clients.functionality.alert.ws.AlertWebService;
import eu.dnetlib.clients.functionality.alert.ws.AlertWebServiceException;
import eu.dnetlib.clients.ws.BaseWebServiceClient;
import eu.dnetlib.domain.functionality.AlertSubscription;
import eu.dnetlib.domain.functionality.AlertTemplate;
import eu.dnetlib.domain.functionality.NotificationEvent;
import eu.dnetlib.domain.functionality.ObjectPage;
import eu.dnetlib.domain.functionality.ResultPage;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import java.util.SortedSet;
import java.util.TreeSet;

public class AlertWebServiceClient
extends BaseWebServiceClient<AlertWebService>
implements AlertService {
    public SortedSet<String> getSupportedAlertModes() {
        TreeSet supportedAlertModes = ((AlertWebService)this.webService).getSupportedAlertModes();
        return supportedAlertModes == null ? new TreeSet() : supportedAlertModes;
    }

    public ObjectPage<AlertTemplate> getTemplates(int pageNumber, int pageSize) throws AlertServiceException {
        try {
            return ((AlertWebService)this.webService).getTemplates(pageNumber, pageSize);
        }
        catch (AlertWebServiceException e) {
            throw new AlertServiceException("error retrieving templates (page: " + pageNumber + ", page size: " + pageSize + ")", (Throwable)e);
        }
    }

    public void addTemplate(AlertTemplate template) throws AlertServiceException {
        try {
            ((AlertWebService)this.webService).addTemplate(template);
        }
        catch (AlertWebServiceException e) {
            throw new AlertServiceException("error adding template " + template, (Throwable)e);
        }
    }

    public void removeTemplate(String templateId) throws AlertServiceException {
        try {
            ((AlertWebService)this.webService).removeTemplate(templateId);
        }
        catch (AlertWebServiceException e) {
            throw new AlertServiceException("error removing template " + templateId, (Throwable)e);
        }
    }

    public ObjectPage<AlertSubscription> getSubscriptions(int pageNumber, int pageSize) throws AlertServiceException {
        try {
            return ((AlertWebService)this.webService).getSubscriptions(pageNumber, pageSize);
        }
        catch (AlertWebServiceException e) {
            throw new AlertServiceException("error retrieving subscriptions (page: " + pageNumber + ", page size: " + pageSize + ")", (Throwable)e);
        }
    }

    public SortedSet<AlertSubscription> getSubscriptions(String alertMode, String subscriber, int limit, int offset) throws AlertServiceException {
        try {
            TreeSet subscriptions = ((AlertWebService)this.webService).getSubscriptions(alertMode, subscriber, limit, offset);
            return subscriptions == null ? new TreeSet() : subscriptions;
        }
        catch (AlertWebServiceException e) {
            throw new AlertServiceException("error retrieving subscriptions with alert mode " + alertMode + " and subscriber like '" + subscriber + "' (limit: " + limit + ", offset: " + offset + ")", (Throwable)e);
        }
    }

    public void addSubscription(AlertSubscription subscription) throws AlertServiceException {
        try {
            ((AlertWebService)this.webService).addSubscription(subscription);
        }
        catch (AlertWebServiceException e) {
            throw new AlertServiceException("error adding subscription " + subscription, (Throwable)e);
        }
    }

    public void enableSubscription(String templateId, URL notificationService, String queryId, String resultId, String alertMode, URI subscriber) throws AlertServiceException {
        try {
            ((AlertWebService)this.webService).enableSubscription(templateId, notificationService, queryId, resultId, alertMode, subscriber);
        }
        catch (AlertWebServiceException e) {
            throw new AlertServiceException("error enabling subscription (template: " + templateId + ", notification service: " + notificationService + ", query: " + queryId + ", result: " + resultId + ", alert mode: " + alertMode + ", subscriber: " + subscriber + ")", (Throwable)e);
        }
    }

    public void disableSubscription(String templateId, URL notificationService, String queryId, String resultId, String alertMode, URI subscriber) throws AlertServiceException {
        try {
            ((AlertWebService)this.webService).disableSubscription(templateId, notificationService, queryId, resultId, alertMode, subscriber);
        }
        catch (AlertWebServiceException e) {
            throw new AlertServiceException("error disabling subscription (template: " + templateId + ", notification service: " + notificationService + ", query: " + queryId + ", result: " + resultId + ", alert mode: " + alertMode + ", subscriber: " + subscriber + ")", (Throwable)e);
        }
    }

    public void removeSubscription(String templateId, URL notificationService, String queryId, String resultId, String alertMode, URI subscriber) throws AlertServiceException {
        try {
            ((AlertWebService)this.webService).removeSubscription(templateId, notificationService, queryId, resultId, alertMode, subscriber);
        }
        catch (AlertWebServiceException e) {
            throw new AlertServiceException("error removing subscription (template: " + templateId + ", notification service: " + notificationService + ", query: " + queryId + ", result: " + resultId + ", alert mode: " + alertMode + ", subscriber: " + subscriber + ")", (Throwable)e);
        }
    }

    public int countAlertResults(URL notificationService, String queryId, Date date, String resultId) throws AlertServiceException {
        try {
            return ((AlertWebService)this.webService).countAlertResults(notificationService, queryId, date, resultId);
        }
        catch (AlertWebServiceException e) {
            throw new AlertServiceException("error counting alert results (notification service: " + notificationService + ", query: " + queryId + ", date: " + date + ", result: " + resultId + ")", (Throwable)e);
        }
    }

    public ResultPage getAlertResults(URL notificationService, String queryId, String resultId, Date fromDate, Date toDate, int limit, int offset) throws AlertServiceException {
        try {
            return ((AlertWebService)this.webService).getAlertResults(notificationService, queryId, resultId, fromDate, toDate, limit, offset);
        }
        catch (AlertWebServiceException e) {
            throw new AlertServiceException("error retrieving alert results (notification service: " + notificationService + ", query: " + queryId + ", result: " + resultId + ", from date: " + fromDate + ", to date: " + toDate + ", limit: " + limit + ", offset: " + offset + ")", (Throwable)e);
        }
    }

    public void alert(URL notificationService, NotificationEvent event) throws AlertServiceException {
        try {
            ((AlertWebService)this.webService).alert(notificationService, event);
        }
        catch (AlertWebServiceException e) {
            throw new AlertServiceException("error receiving notification from notification service " + notificationService + " about event " + event, (Throwable)e);
        }
    }
}

