/**
 * 
 */
package eu.dnetlib.clients.data.index.ws;

import java.util.List;

import org.apache.log4j.Logger;

import eu.dnetlib.api.DriverServiceException;
import eu.dnetlib.api.data.IndexService;
import eu.dnetlib.api.data.IndexServiceException;
import eu.dnetlib.domain.EPR;
import eu.dnetlib.domain.ServiceIdentity;
import eu.dnetlib.domain.data.Hint;
import eu.dnetlib.domain.enabling.Notification;
import eu.dnetlib.functionality.index.client.IndexClient;

/**
 * @author Nikon Gasparis 
 */
public class IndexWSClient implements IndexService {

	private static Logger logger = Logger.getLogger(IndexWSClient.class);
	
	IndexClient client = null;
	
	public void setClient(IndexClient client) {
		this.client = client;
	}	
	
	public IndexClient getClient() {
		return client;
	}
	
	public void setWebService(Object webService) {
		this.client = (IndexClient) webService;
	}
	
	public EPR getBrowsingStatistics(String query, String index,
			String mdFormatId, String layoutId) throws IndexServiceException {
		throw new UnsupportedOperationException();
/*		try {
			if (logger.isDebugEnabled()) {
				logger.debug("Request Browsing Statistics for \""
						+ query + "\" on index " + index
						+ " with " + mdFormatId + "/" + layoutId);
			}
			W3CEndpointReference w3cEpr = client.getBrowsingStatistics(
					query, index, mdFormatId, layoutId);
			EPR epr =  EPRUtils.createEPR(w3cEpr);
			if (logger.isDebugEnabled()) {
				logger.debug("Result EPR: \"" + epr + "\"");
			}
			return epr;
		
		} catch (eu.dnetlib.functionality.index.client.IndexClientException e) {
			throw new IndexServiceException(
					"Error calling index: " + e.getMessage());
		}
*/	}

	public String getIndexStatistics(String index)
			throws IndexServiceException {
		throw new UnsupportedOperationException();
/*		try {
			if (logger.isDebugEnabled()) {
				logger.debug("Request Index Statistics on index " + index);
			}
			return client.getIndexStatistics(index);
			
		} catch (eu.dnetlib.functionality.index.client.IndexClientException e) {
			throw new IndexServiceException(
					"Error calling index: " + e.getMessage());
		}
*/	}

	public List<String> getListOfIndices() throws IndexServiceException {
		throw new UnsupportedOperationException();
/*		if (logger.isDebugEnabled()) {
			logger.debug("Request List of Indices");
		}
		String[] list = client.getListOfIndices();
		if (list == null) {
			if (logger.isDebugEnabled()) {
				logger.debug("List is null");
			}
			return null;
		} else {
			if (logger.isDebugEnabled()) {
				logger.debug("List contains " + list.length + " elements");
			}
			return Arrays.asList(list);
		}
*/	}

	public String getListOfIndicesCSV() throws IndexServiceException {
		throw new UnsupportedOperationException();
/*		if (logger.isDebugEnabled()) {
			logger.debug("Request List of Indices CSV");
		}
		return client.getListOfIndicesCSV();
*/	}

	public EPR indexLookup(
			String id, String query, String mdformat, String layout)
			throws IndexServiceException {
		throw new UnsupportedOperationException();
/*		try {
			if (logger.isDebugEnabled()) {
				logger.debug("Index Lookup for \"" + query + "\" on index " + id
						+ " using " + mdformat + "/" + layout);
			}
			W3CEndpointReference w3cEpr =
					client.indexLookup(id, query, mdformat, layout);
			EPR epr =  EPRUtils.createEPR(w3cEpr);
			if (logger.isDebugEnabled()) {
				logger.debug("Result EPR: \"" + epr + "\"");
			}
			return epr;
			
		} catch (eu.dnetlib.functionality.index.client.IndexClientException e) {
			throw new IndexServiceException(
					"Error calling index: " + e.getMessage());
		}
*/	}

	public ServiceIdentity identify() {
		throw new UnsupportedOperationException();
	}

	public void notify(Notification notification)
			throws DriverServiceException {
		throw new UnsupportedOperationException();
	}

	@Override
	public Hint suggestiveSearch(String id, String query,
			String mdformat, String layout, String heuristicProfileName)
			throws IndexServiceException {
		
		// TODO Replace with the real thing
		// suggestAlternateTerm(String mdFormat, String layout, String interpretation, String heuristicProfileName, String term);
		logger.debug("Ask hint for '" + query+"'");
		Hint hint = new Hint();
		
		if (query.equals("query=(tost)")) {
			hint.setAlternateTerm("(test)");
			hint.setAutoFollowHint(false);
			
		} else if (query.equals("query=(luve)")) {
			hint.setAlternateTerm("love");
			hint.setAutoFollowHint(true);
			
		} else {
			hint.setAlternateTerm(null);
		}
		
		
		
		return hint;
	}
	
}
