package eu.dnetlib.clients.enabling.islookup.ws;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;

import eu.dnetlib.api.enabling.ISLookUpService;
import eu.dnetlib.api.enabling.ISLookUpServiceException;
import eu.dnetlib.domain.ServiceIdentity;
import eu.dnetlib.domain.enabling.Notification;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;

public class ISLookUpClient implements ISLookUpService {
	private static Logger logger = Logger.getLogger(ISLookUpClient.class);
	
	private eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService isLookUp = null;

	public void setIsLookUp(
			eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService isLookUp) {
		this.isLookUp = isLookUp;
	}
	
	public void setWebService(Object webService) {
		this.isLookUp = (eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService) webService;
	}

	public List<String> quickSearchProfile(String XQuery)
			throws ISLookUpServiceException {
		try {
			List<String> list = isLookUp.quickSearchProfile(XQuery);
			
			if (list != null)
				return list;
			else
				return new ArrayList<String>();
			
		} catch (ISLookUpException e) {
			throw new ISLookUpServiceException(e);
		} catch (Exception e) {
			logger.error(e);
			
			throw new ISLookUpServiceException("Error performing quick search");
		}
	}

	public String getResourceProfile(String profId)
			throws ISLookUpServiceException {
		try {
			return isLookUp.getResourceProfile(profId);
		} catch (ISLookUpException e) {
			throw new ISLookUpServiceException(e);
		} catch (Exception e) {
			logger.error(e);
			
			throw new ISLookUpServiceException("Error getting profile by id");
		}
	}

	public String getResourceProfileByQuery(String XQuery)
			throws ISLookUpServiceException {
		try {
			return isLookUp.getResourceProfileByQuery(XQuery);
		} catch (ISLookUpException e) {
			throw new ISLookUpServiceException(e);
		} catch (Exception e) {
			logger.error(e);
			
			throw new ISLookUpServiceException("Error getting profile by query");
		}
	}

	public String getResourceTypeSchema(String resourceType)
			throws ISLookUpServiceException {
		try {
			return isLookUp.getResourceTypeSchema(resourceType);
		} catch (ISLookUpException e) {
			throw new ISLookUpServiceException(e);
		}  catch (Exception e) {
			logger.error(e);
			
			throw new ISLookUpServiceException("Error getting schema");
		}
	}

	public List<String> listResourceTypes() throws ISLookUpServiceException {
		try {
			return isLookUp.listResourceTypes();
		} catch (ISLookUpException e) {
			throw new ISLookUpServiceException(e);
		} catch (Exception e) {
			logger.error(e);
			
			throw new ISLookUpServiceException("Error getting resource types");
		}
	}

	public ServiceIdentity identify() {
		// TODO coooooodeee
		return null;
		// return isLookUp.identify();
	}

	@Override
	public void notify(Notification notification) {
		// TODO Auto-generated method stub
		throw new UnsupportedOperationException();
	}
}