/**
 * 
 */
package eu.dnetlib.clients.enabling.resultset.ws;

import java.util.ArrayList;
import java.util.List;

import javax.xml.ws.soap.SOAPFaultException;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.log4j.Logger;

import eu.dnetlib.api.DriverServiceException;
import eu.dnetlib.api.enabling.ResultSetServiceException;
import eu.dnetlib.domain.EPR;
import eu.dnetlib.domain.ServiceIdentity;
import eu.dnetlib.domain.enabling.Notification;
import eu.dnetlib.enabling.resultset.rmi.ResultSetException;
import eu.dnetlib.enabling.resultset.rmi.ResultSetService;
import eu.dnetlib.utils.EPRUtils;
import eu.dnetlib.utils.ServiceIdentityFactory;

/**
 * @author stoumpos
 * 
 */
public class ResultSetServiceWSClient implements
		eu.dnetlib.api.enabling.ResultSetService {
	private Logger logger = Logger.getLogger(ResultSetServiceWSClient.class);
	
	private int pageSize = 500;
	private eu.dnetlib.enabling.resultset.rmi.ResultSetService client = null;

	public ResultSetServiceWSClient() {
		super();
	}

	public ResultSetServiceWSClient(String url) {
		JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
		factory
				.setServiceClass(eu.dnetlib.enabling.resultset.rmi.ResultSetService.class);
		factory.setAddress(url);

		client = (eu.dnetlib.enabling.resultset.rmi.ResultSetService) factory
				.create();
	}

	public eu.dnetlib.enabling.resultset.rmi.ResultSetService getClient() {
		return client;
	}

	public void setClient(
			eu.dnetlib.enabling.resultset.rmi.ResultSetService client) {
		this.client = client;
	}

	public void closeRS(String rsId) {
		client.closeRS(rsId);
	}

	public EPR createPullRS(String dataProviderServiceAddress, String bdId,
			int initialPageSize, int expiryTime, String styleSheet,
			Integer keepAliveTime, Integer total) {
		return createEPR(client.createPullRS(dataProviderServiceAddress, bdId,
				initialPageSize, expiryTime, styleSheet, keepAliveTime, total));
	}

	public EPR createPullRSEPR(EPR dataProviderEPR, String bdId,
			int initialPageSize, int expiryTime, String styleSheet,
			Integer keepAliveTime, Integer total) {

		return createEPR(client.createPullRSEPR(createW3CEPR(dataProviderEPR),
				bdId, initialPageSize, expiryTime, styleSheet, keepAliveTime,
				total));
	}

	public EPR createPushRS(int expiryTime, int keepAliveTime)
			throws ResultSetServiceException {
		try {
			return createEPR(client.createPushRS(expiryTime, keepAliveTime));
		} catch (ResultSetException rse) {
			throw new ResultSetServiceException("Error creating push rs.", rse);
		} catch (SOAPFaultException sfe) {
			throw new ResultSetServiceException(
					"Error getting number of elements.", sfe);
		}
	}

	public int getNumberOfElements(String rsId)
			throws ResultSetServiceException {
		try {
			return client.getNumberOfElements(rsId);
		} catch (ResultSetException rse) {
			throw new ResultSetServiceException(
					"Error getting number of elements.", rse);
		} catch (SOAPFaultException sfe) {
			throw new ResultSetServiceException(
					"Error getting number of elements.", sfe);
		}
	}

	public String getProperty(String rsId, String name)
			throws ResultSetServiceException {
		try {
			return client.getProperty(rsId, name);
		} catch (ResultSetException rse) {
			throw new ResultSetServiceException("Error getting property.", rse);
		}
	}

	public String getRSStatus(String rsId) throws ResultSetServiceException {
		try {
			return client.getRSStatus(rsId);
		} catch (ResultSetException rse) {
			throw new ResultSetServiceException("Error getting rs status.", rse);
		} catch (SOAPFaultException sfe) {
			throw new ResultSetServiceException(
					"Error getting result set state.", sfe);
		}
	}

	public List<String> getResult(String rsId, int fromPosition,
			int toPosition, String requestMode)
			throws ResultSetServiceException {
		logger.debug("Returning results from " + fromPosition + " to " + toPosition);
		logger.debug("HELLO!");
		
		try {
			List<String> list = new ArrayList<String>();
			int requestSize = (toPosition - fromPosition + 1);
			int pages = requestSize < pageSize ? 0 : (requestSize / pageSize);
			int left = requestSize % pageSize;

			logger.debug("PAGES " + pages);
			
			for (int i = 0; i < pages; i++) {
				logger.debug("FROM " + (fromPosition + i * pageSize));
				logger.debug("TO " + (fromPosition + (i + 1)* pageSize - 1));
				List<String> res = client.getResult(rsId,
						fromPosition + i * pageSize, fromPosition + (i + 1)
						* pageSize - 1, requestMode);
		
				if (res != null)
					list.addAll(res);
				logger.debug("LIST SIZE " + list.size());
			}

			logger.debug("LEFT " + left);
			if (left > 0)
				list.addAll(client.getResult(rsId, toPosition - left + 1, toPosition,
						requestMode));

			logger.debug("LIST SIZE " + list.size());
			return list;
		} catch (ResultSetException rse) {
			throw new ResultSetServiceException("Error getting result.", rse);
		} catch (SOAPFaultException sfe) {
			throw new ResultSetServiceException(
					"Error getting results.", sfe);
		}
	}
	
	public static void main(String[] args) {
		System.out.println(1%10);
	}

	public String populateRS(String rsId, List<String> elements)
			throws ResultSetServiceException {
		int requestSize = elements.size();
		int pages = requestSize / pageSize;
		int left = requestSize % pageSize;

		try {
			for (int i = 0; i < pages; i++)
				client.populateRS(rsId, elements.subList(i*pageSize, (i+1)*pageSize));
			
			if (left > 0)
				client.populateRS(rsId, elements.subList(pages*pageSize, requestSize));

			return null;
		} catch (ResultSetException rse) {
			throw new ResultSetServiceException(
					"Error getting number of elements.", rse);
		} catch (SOAPFaultException sfe) {
			throw new ResultSetServiceException(
					"Error getting number of elements.", sfe);
		}
	}

	static EPR createEPR(W3CEndpointReference w3cEpr) {
		return EPRUtils.createEPR(w3cEpr);
	}

	static W3CEndpointReference createW3CEPR(EPR epr) {
		return EPRUtils.createW3CEPR(epr);
	}

	@Override
	public ServiceIdentity identify() {
		return ServiceIdentityFactory.parseIdentity(client.identify());
	}

	@Override
	public void notify(Notification notification) throws DriverServiceException {
		throw new UnsupportedOperationException();
	}

	public void setWebService(Object webService) {
		this.client = (ResultSetService) webService;
	}

	public void setPageSize(int pageSize) {
		this.pageSize = pageSize;
	}
}
