package eu.dnetlib.clients.functionality.notification.ws;

import java.net.URL;
import java.util.Date;
import java.util.SortedSet;
import java.util.TreeSet;

import eu.dnetlib.api.functionality.NotificationService;
import eu.dnetlib.api.functionality.NotificationServiceException;
import eu.dnetlib.clients.ws.BaseWebServiceClient;
import eu.dnetlib.domain.functionality.NotificationEvent;
import eu.dnetlib.domain.functionality.NotificationQuery;
import eu.dnetlib.domain.functionality.NotificationResult;
import eu.dnetlib.domain.functionality.NotificationSchedule;
import eu.dnetlib.domain.functionality.NotificationSubscription;
import eu.dnetlib.domain.functionality.ObjectPage;
import eu.dnetlib.domain.functionality.ResultPage;

/**
 * This class implements a notification service using a notification web service.
 * @author thanos@di.uoa.gr
 * @see eu.dnetlib.api.functionality.NotificationService
 * @see NotificationWebService
 * @see eu.dnetlib.api.functionality.NotificationServiceException
 * 
 */
public class NotificationWebServiceClient extends BaseWebServiceClient<NotificationWebService> implements NotificationService {
	@Override
	public SortedSet<String> getSupportedQueryLanguages() {
		final SortedSet<String> supportedQueryLanguages = webService.getSupportedQueryLanguages();
		return (supportedQueryLanguages == null) ? new TreeSet<String>() : supportedQueryLanguages;
	}

	@Override
	public ObjectPage<NotificationQuery> getQueries(final int pageNumber, final int pageSize) throws NotificationServiceException {
		try {
			return webService.getQueries(pageNumber, pageSize);
		} catch (final NotificationWebServiceException e) {
			throw new NotificationServiceException("error retrieving queries (page: " + pageNumber + ", page size: " + pageSize + ")", e);
		}
	}

	@Override
	public void addQuery(final NotificationQuery query) throws NotificationServiceException {
		try {
			webService.addQuery(query);
		} catch (final NotificationWebServiceException e) {
			throw new NotificationServiceException("error adding query " + query, e);
		}
	}
	
	@Override
	public void removeQuery(final String queryId) throws NotificationServiceException {
		try {
			webService.removeQuery(queryId);
		} catch (final NotificationWebServiceException e) {
			throw new NotificationServiceException("error removing query " + queryId, e);
		}
	}
	
	@Override
	public ResultPage executeQuery(final String queryId, final String resultId, final Date fromDate, final Date toDate, final int limit, final int offset) throws NotificationServiceException {
		try {
			return webService.executeQuery(queryId, resultId, fromDate, toDate, limit, offset);
		} catch (final NotificationWebServiceException e) {
			throw new NotificationServiceException("error executing query " + queryId + "(result: " + resultId + ", from date: " + fromDate + ", to date: " + toDate + ", limit: " + limit + ", offset: " + offset + ")", e);
		}
	}
	
	@Override
	public ObjectPage<NotificationSchedule> getSchedules(final int pageNumber, final int pageSize) throws NotificationServiceException {
		try {
			return webService.getSchedules(pageNumber, pageSize);
		} catch (final NotificationWebServiceException e) {
			throw new NotificationServiceException("error retrieving schedules (page: " + pageNumber + ", page size: " + pageSize + ")", e);
		}
	}
	
	@Override
	public void addSchedule(final NotificationSchedule schedule) throws NotificationServiceException {
		try {
			webService.addSchedule(schedule);
		} catch (final NotificationWebServiceException e) {
			throw new NotificationServiceException("error adding schedule " + schedule, e);
		}
	}
	
	@Override
	public void enableSchedule(final String queryId) throws NotificationServiceException {
		try {
			webService.enableSchedule(queryId);
		} catch (final NotificationWebServiceException e) {
			throw new NotificationServiceException("error enabling schedule " + queryId, e);
		}
	}

	@Override
	public void disableSchedule(final String queryId) throws NotificationServiceException {
		try {
			webService.disableSchedule(queryId);
		} catch (final NotificationWebServiceException e) {
			throw new NotificationServiceException("error disabling schedule " + queryId, e);
		}
	}
	
	@Override
	public void removeSchedule(final String queryId) throws NotificationServiceException {
		try {
			webService.removeSchedule(queryId);
		} catch (final NotificationWebServiceException e) {
			throw new NotificationServiceException("error removing schedule " + queryId, e);
		}
	}
	
	@Override
	public ObjectPage<NotificationEvent> getEvents(final int pageNumber, final int pageSize) throws NotificationServiceException {
		try {
			return webService.getEvents(pageNumber, pageSize);
		} catch (final NotificationWebServiceException e) {
			throw new NotificationServiceException("error retrieving events (page: " + pageNumber + ", page size: " + pageSize + ")", e);
		}
	}
	
	@Override
	public ObjectPage<NotificationResult> getResults(final int pageNumber, final int pageSize) throws NotificationServiceException {
		try {
			return webService.getResults(pageNumber, pageSize);
		} catch (final NotificationWebServiceException e) {
			throw new NotificationServiceException("error retrieving results (page: " + pageNumber + ", page size: " + pageSize + ")", e);
		}
	}
	
	@Override
	public NotificationResult getResult(final String queryId, final Date date, final String resultId) throws NotificationServiceException {
		try {
			return webService.getResult(queryId, date, resultId);
		} catch (final NotificationWebServiceException e) {
			throw new NotificationServiceException("error retrieving result " + resultId + " of event " + date + " of query " + queryId, e);
		}
	}
	
	@Override
	public NotificationResult getPreviousResult(final String queryId, final Date date, final String resultId) throws NotificationServiceException {
		try {
			return webService.getPreviousResult(queryId, date, resultId);
		} catch (final NotificationWebServiceException e) {
			throw new NotificationServiceException("error retrieving result " + resultId + " of the previous event of event " + date + " of query " + queryId, e);
		}
	}
	
	@Override
	public ObjectPage<NotificationSubscription> getSubscriptions(final int pageNumber, final int pageSize) throws NotificationServiceException {
		try {
			return webService.getSubscriptions(pageNumber, pageSize);
		} catch (final NotificationWebServiceException e) {
			throw new NotificationServiceException("error retrieving subscriptions (page: " + pageNumber + ", page size: " + pageSize + ")", e);
		}
	}
	
	@Override
	public void addSubscription(final NotificationSubscription subscription) throws NotificationServiceException {
		try {
			webService.addSubscription(subscription);
		} catch (final NotificationWebServiceException e) {
			throw new NotificationServiceException("error adding subscription " + subscription, e);
		}
	}
	
	@Override
	public void enableSubscription(final String queryId, final URL alertService) throws NotificationServiceException {
		try {
			webService.enableSubscription(queryId, alertService);
		} catch (final NotificationWebServiceException e) {
			throw new NotificationServiceException("error enabling subscription (query: " + queryId + ", alert service: " + alertService + ")", e);
		}
	}
	
	@Override
	public void disableSubscription(final String queryId, final URL alertService) throws NotificationServiceException {
		try {
			webService.disableSubscription(queryId, alertService);
		} catch (final NotificationWebServiceException e) {
			throw new NotificationServiceException("error disabling subscription (query: " + queryId + ", alert service: " + alertService + ")", e);
		}
	}
	
	@Override
	public void removeSubscription(final String queryId, final URL alertService) throws NotificationServiceException {
		try {
			webService.removeSubscription(queryId, alertService);
		} catch (final NotificationWebServiceException e) {
			throw new NotificationServiceException("error removing subscription (query: " + queryId + ", alert service: " + alertService + ")", e);
		}
	}
}
