package eu.dnetlib.clients.functionality.validator.ws;

import java.util.List;

import eu.dnetlib.api.functionality.ValidatorService;
import eu.dnetlib.api.functionality.ValidatorServiceException;
import eu.dnetlib.clients.ws.BaseWebServiceClient;
import eu.dnetlib.domain.functionality.validator.JobForValidation;
import eu.dnetlib.domain.functionality.validator.RuleSet;
import eu.dnetlib.domain.functionality.validator.StoredJob;

public class ValidatorWebServiceClient extends
		BaseWebServiceClient<ValidatorWebService> implements ValidatorService {

	@Override
	public StoredJob getStoredJob(int jobId, String groupBy)
			throws ValidatorServiceException {
		return this.webService.getStoredJob(jobId, groupBy);
	}

	@Override
	public List<StoredJob> getStoredJobs(String userMail, String jobType, Integer offset, Integer limit, String dateFrom, String dateTo)
			throws ValidatorServiceException {
		return this.webService.getStoredJobs(userMail, jobType, offset, limit, dateFrom, dateTo);
	}

	@Override
	public List<StoredJob> getStoredJobsNew(String userMail, String jobType, Integer offset, Integer limit, String dateFrom, String dateTo, String jobStatus)
			throws ValidatorServiceException {
		return this.webService.getStoredJobsNew(userMail, jobType, offset, limit, dateFrom, dateTo, jobStatus);
	}

	@Override
	public int getStoredJobsTotalNumber(String userMail, String jobType)
			throws ValidatorServiceException {
		return this.webService.getStoredJobsTotalNumber(userMail, jobType);
	}

	@Override
	public int getStoredJobsTotalNumberNew(String userMail, String jobType, String jobStatus)
			throws ValidatorServiceException {
		return this.webService.getStoredJobsTotalNumberNew(userMail, jobType, jobStatus);
	}

	@Override
	public List<RuleSet> getRuleSets() throws ValidatorServiceException {
		return this.webService.getRuleSets();
	}

	@Override
	public void submitValidationJob(JobForValidation job)
			throws ValidatorServiceException {
		this.webService.submitValidationJob(job);
	}



}
