/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.clients.utils.ws;

import eu.dnetlib.api.DriverService;
import eu.dnetlib.api.enabling.A2Service;
import eu.dnetlib.clients.utils.ws.CompatibilityEndpointResolver;
import eu.dnetlib.clients.utils.ws.CompatibilityServiceLocator;
import eu.dnetlib.clients.utils.ws.JaxwsServiceLocator;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.tools.ServiceResolver;
import eu.dnetlib.enabling.tools.registration.ServiceNameResolver;
import eu.dnetlib.soap.cxf.StandaloneCxfEndpointReferenceBuilder;
import eu.dnetlib.utils.resolver.ServiceClientFactory;
import eu.dnetlib.utils.resolver.TransportConfiguration;
import gr.uoa.di.driver.util.FallBackServiceLocator;
import gr.uoa.di.driver.util.RefreshingServiceLocator;
import gr.uoa.di.driver.util.ServiceLocator;
import gr.uoa.di.driver.util.ServiceLocatorFactory;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.log4j.Logger;

public class CompatibilityServiceLocatorFactory
implements ServiceLocatorFactory {
    private static Logger logger = Logger.getLogger(CompatibilityServiceLocatorFactory.class);
    private TransportConfiguration configuration = null;
    private Map<Class<?>, ServiceClientFactory<?>> clientMap = null;
    private CompatibilityEndpointResolver endpointResolver = null;
    private StandaloneCxfEndpointReferenceBuilder eprBuilder = null;
    private ServiceNameResolver serviceNameResolver = null;
    private ServiceResolver serviceResolver = null;
    private ScheduledExecutorService executor = Executors.newScheduledThreadPool(2);
    private long locatorRefreshPeriod = 300000L;
    private UniqueServiceLocator serviceLocator = null;

    public void init() {
        logger.debug((Object)"Init...");
    }

    public <S extends DriverService> ServiceLocator<S> newServiceLocator(Class<S> serviceClass) {
        if (serviceClass.equals(A2Service.class)) {
            throw new IllegalArgumentException("Cannot create dynamic locator for A2Service");
        }
        return this.newRefreshingServiceLocator(this.newDynamicServiceLocator(serviceClass));
    }

    public <S extends DriverService> ServiceLocator<S> newServiceLocator(Class<S> serviceClass, String serviceUrl) {
        return new FallBackServiceLocator(this.newRefreshingServiceLocator(this.newDynamicServiceLocator(serviceClass)), this.newUrlServiceLocator(serviceClass, serviceUrl));
    }

    private <S extends DriverService> ServiceLocator<S> newRefreshingServiceLocator(ServiceLocator<S> locator) {
        RefreshingServiceLocator rLocator = new RefreshingServiceLocator();
        rLocator.setExecutor(this.executor);
        rLocator.setLocator(locator);
        rLocator.setPeriod(this.locatorRefreshPeriod);
        return rLocator;
    }

    private <S extends DriverService> ServiceLocator<S> newUrlServiceLocator(Class<S> serviceClass, String serviceUrl) {
        JaxwsServiceLocator<S> locator = new JaxwsServiceLocator<S>();
        locator.setEprBuilder(this.eprBuilder);
        locator.setServiceClass(serviceClass);
        locator.setUrl(serviceUrl);
        locator.setResolver(this.endpointResolver);
        return locator;
    }

    private <S extends DriverService> ServiceLocator<S> newDynamicServiceLocator(Class<S> serviceClass) {
        CompatibilityServiceLocator<Object> locator = new CompatibilityServiceLocator<Object>();
        ServiceClientFactory<?> clientFactory = this.clientMap.get(serviceClass);
        locator.setClientFactory(clientFactory);
        locator.setServiceClass(serviceClass);
        locator.setServiceLocator(this.serviceLocator);
        return locator;
    }

    public StandaloneCxfEndpointReferenceBuilder getEprBuilder() {
        return this.eprBuilder;
    }

    public void setEprBuilder(StandaloneCxfEndpointReferenceBuilder eprBuilder) {
        this.eprBuilder = eprBuilder;
    }

    public ServiceNameResolver getServiceNameResolver() {
        return this.serviceNameResolver;
    }

    public void setServiceNameResolver(ServiceNameResolver serviceNameResolver) {
        this.serviceNameResolver = serviceNameResolver;
    }

    public ServiceResolver getServiceResolver() {
        return this.serviceResolver;
    }

    public void setServiceResolver(ServiceResolver serviceResolver) {
        this.serviceResolver = serviceResolver;
    }

    public TransportConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(TransportConfiguration configuration) {
        this.configuration = configuration;
    }

    public CompatibilityEndpointResolver getEndpointResolver() {
        return this.endpointResolver;
    }

    public void setEndpointResolver(CompatibilityEndpointResolver endpointResolver) {
        this.endpointResolver = endpointResolver;
    }

    public Map<Class<?>, ServiceClientFactory<?>> getClientMap() {
        return this.clientMap;
    }

    public void setClientMap(Map<Class<?>, ServiceClientFactory<?>> clientMap) {
        this.clientMap = clientMap;
    }

    public UniqueServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    public void setServiceLocator(UniqueServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }
}

